/* ASMLINK.C
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *		Assembly Interface to Scheme				*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: L. Bartholdi & M. Vuilleumier	Date: 1992		*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#include	<stdarg.h>
#include	<stdlib.h>
#include	"scheme.h"

int	asm_link( int n_args, ...)
{
	int		i;
	REGPTR		sarg;
	LINKARG		carg[NUMARGS];
	LINKVAL		cresult;
	REGPTR		sresult;
	int             stat;
	va_list		vlist;

	va_start(vlist, n_args);		/* Convert every regptr */
	for (i = 0; i < n_args; i++) {		/* Warning: this structure may be wrong */
						/* optimized (don't use i--)... (Thanks Borland) */
		sarg = va_arg(vlist, REGPTR);
		switch( gettype(sarg) )
		{
		case STRTYPE:
			carg[n_args-1-i].type = STR;
			carg[n_args-1-i].item.s = string_asciz(sarg);
			break;
		case BIGTYPE:
		case FIXTYPE:
			carg[n_args-1-i].type = INTEGER;
			carg[n_args-1-i].item.i = int2long(sarg);
			break;
		case FLOTYPE:
			carg[n_args-1-i].type = FLOAT;
			carg[n_args-1-i].item.f = reg2c(sarg)->flonum.data;
			break;
		case CHARTYPE:
			carg[n_args-1-i].type = CHARACTER;
			carg[n_args-1-i].item.c = sarg->disp & 0xff;
			break;
		case SYMTYPE:
		case LISTTYPE:
			carg[n_args-1-i].type = BOOLEAN;
			carg[n_args-1-i].item.b = (sarg->page == CORRPAGE(NIL_PAGE)) && 
					      (sarg->disp == NIL_DISP);
			break;
		default:
			return	-1;
		}
	}
	sresult = sarg;				/* first arg was pushed first, so now it it the last arg... */
	va_end(vlist);

	/* all arguments ready-- call the interface routine */
	stat = link(&cresult, n_args-1, carg);

	/* release memory allocated for strings */
	for (i = 0; i < n_args; i++) {
		if (carg[i].type == STR)
			rlsstr(carg[i].item.s);
	}

	/*
	 * fetch result returned from low level return and make it a Scheme
	 * object
	 */
	switch (stat) {
	case NOVALUE:
		break;

	case BOOLEAN:
		bool2scm(sresult, cresult.b);
		break;
	case INTEGER:
		long2int(sresult, cresult.i);
		break;
	case FLOAT:
		alloc_flonum(sresult, cresult.f);
		break;
	case CHARACTER:
		sresult->page = ADJPAGE(SPECCHAR);
		sresult->disp = cresult.c;
		break;
	case STR:
		alloc_string(sresult, cresult.s);
		free(cresult.s);
		break;
	case STATSTR:
		alloc_string(sresult, cresult.s);
		break;
	case SCHEME:
		*sresult = cresult.r;
		break;
	default:
		return	-1;
	}

	return	0;
}
