;* PRINTATM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Print an atom (interpreter support)			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	small
LOCALS	@@

	INCLUDE	"scheme.ash"
	INCLUDE "interprt.ash"

CODESEG
;****************************************************************************
;	Print an S-Expression (w/ slashification)
; Purpose: Scheme interpreter support to output an s-expression to a port.
;****************************************************************************
PROC	spprin1
	get2op
	save	<si>
	xor	bx, bx
	mov	bl, ah
	add	bx, OFFSET regs 	; bx = port object
	xor	ah, ah
	add	ax, OFFSET regs 	; ax = s-expression pointer
	mov	di, ax
	mov	cx, 1 			; write indicator
	call	get_port C, bx, cx 	; get port address
	test	ax, ax 			; check return status
	jz	@@ok
	lea	bx, [@@msg]
DATASEG
@@msg	DB	"WRITE", 0
CODESEG
	jmp	src_err 		; link to error handler
@@ok:
	mov	[show], SP_OUTPUT or SP_SEPARE
call_sprint:
	mov	bx, [(REG di).page]
	shr	bx, 1
	call	sprint C, bx, [(REG di).disp], [tmp_reg.page], [tmp_reg.disp]
ret_nonprintable:
	mov	[(REG di).page], NPR_PAGE*2
	mov	[(REG di).disp], NPR_DISP
	jmp	next_pc
ENDP	spprin1

;****************************************************************************
;	Print an S-Expression (w/o slashification)
; Purpose: Scheme interpreter support to output an s-expression to a port.
;****************************************************************************
PROC	spprinc
	get2op
	save	<si>
	xor	bx, bx
	mov	bl, ah
	add	bx, OFFSET regs 	; bx = port object
	xor	ah, ah
	add	ax, OFFSET regs 	; ax = s-expression pointer
	mov	di, ax
	mov	cx, 1
	push	es			; save es over C call
	call	get_port C, bx, cx	; get port address
	pop	es
	test	ax, ax 			; check return status
	jz	@@ok
	lea	bx, [@@msg]
DATASEG
@@msg	DB	"DISPLAY", 0
CODESEG
	jmp	src_err
@@ok:
	mov	[show], SP_OUTPUT
	jmp	call_sprint
ENDP	spprinc

;****************************************************************************
;	Print an S-Expression (w/ spacing control)
; Purpose: Scheme interpreter support to output an s-expression to a port.
;****************************************************************************
PROC	spprint
	get2op
	save	<si>
	xor	bx, bx
	mov	bl, ah
	add	bx, OFFSET regs 	; bx = port object
	xor	ah, ah
	add	ax, OFFSET regs 	; ax = s-expression pointer
	mov	di, ax
	mov	cx, 1
	call	get_port C, bx, cx	; get port address
	test	ax, ax 			; check return status
	jz	@@ok
	lea	bx, [@@msg]
DATASEG
@@msg	DB	"PRINT", 0
CODESEG
	jmp	src_err
@@ok:
	mov	[show], SP_OUTPUT
	mov	dx, SPECCHAR
	mov	bx, LF 			; line feed
	call	sprint C, dx, bx, [tmp_reg.page], [tmp_reg.disp]
	mov	[show], SP_OUTPUT or SP_SEPARE
	mov	bx, [(REG di).page]
	shr	bx, 1
	call	sprint C, bx, [(REG di).disp], [tmp_reg.page], [tmp_reg.disp]
	mov	bx, SPACE
	mov	dx, SPECCHAR
	mov	[show], SP_OUTPUT
	call	sprint C, dx, bx, [tmp_reg.page], [tmp_reg.disp]
	jmp	ret_nonprintable
ENDP	spprint

;****************************************************************************
;	Print a "newline" character
; Purpose: Scheme interpreter support to output a newline character to a port.
;****************************************************************************
PROC	spnewlin
	get1op
	save	<si>
	add	ax, OFFSET regs 	; ax = port object
	mov	cx, 1
	call	get_port C, ax, cx 	; get port address
	test	ax, ax 			; check return status
	jz	@@ok
	lea	bx, [@@msg]
DATASEG
@@msg	DB	"NEWLINE", 0
CODESEG
	jmp	src_err
@@ok:
	mov	[show], SP_OUTPUT
	mov	bx, SPECCHAR
	mov	dx, LF 			; linefeed
	call	sprint C, bx, dx, [tmp_reg.page], [tmp_reg.disp]
	jmp	next_pc
ENDP	spnewlin

;****************************************************************************
;	Find Print-length of an S-Expression
; Purpose: Scheme interpreter support to determine the print length of a scheme object.
;****************************************************************************
PROC	prt_len
	get1op
	save	<si>
	add	ax, OFFSET regs 	; ax = port object
	mov	di, ax
	mov	[show], 0
	mov	dx, OUT_PAGE*2
	mov	cx, OUT_DISP
	mov	bx, [(REG di).page]
	shr	bx, 1 			; correct page number
	call	sprint C, bx, [(REG di).disp], dx, cx
	mov	[(REG di).page], SPECFIX*2
	mov	[(REG di).disp], ax ; get the print length
	jmp	next_pc
ENDP	prt_len
	END

