;* ASSEMBLY.ASH
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		VM Assembly language macro support			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************/
; Register equates
R0	= 0 
R1	= 4 
R2	= 8 
R3	= 12 
R4	= 16 
R5	= 20 
R6	= 24 
R7	= 28 
R8	= 32 
R9	= 36 
R10	= 40 
R11	= 44 
R12	= 48 
R13	= 52 
R14	= 56 
R15	= 60 
R16	= 64 
R17	= 68 
R18	= 72 
R19	= 76 
R20	= 80 
R21	= 84 
R22	= 88 
R23	= 92 
R24	= 96 
R25	= 100 
R26	= 104 
R27	= 108 
R28	= 112 
R29	= 116 
R30	= 120 
R31	= 124 
R32	= 128 
R33	= 132 
R34	= 136 
R35	= 140 
R36	= 144 
R37	= 148 
R38	= 152 
R39	= 156 
R40	= 160 
R41	= 164 
R42	= 168 
R43	= 172 
R44	= 176 
R45	= 180 
R46	= 184 
R47	= 188 
R48	= 192 
R49	= 196 
R50	= 200 
R51	= 204 
R52	= 208 
R53	= 212 
R54	= 216 
R55	= 220 
R56	= 224 
R57	= 228 
R58	= 232 
R59	= 236 
R60	= 240 
R61	= 244 
R62	= 248 
R63	= 252 
	
;     Instruction macros
MACRO	VM_MOV	dest, src 
	DB	0, dest, src 
ENDM	
	
MACRO	VM_MVC	dest, numb 
	DB	1, dest, numb 
ENDM	
	
MACRO	VM_MVI	dest, val 
	DB	2, dest, val 
ENDM	
	
MACRO	VM_NIL	dest 
	DB	3, dest 
ENDM	
	
MACRO	VM_MVL	dest, entry 
	DB	4, dest, entry 
ENDM	
	
MACRO	VM_MVG dest, src 
	DB	7, dest, src 
ENDM	
	
MACRO	VM_MVF dest, src
	DB	8, dest, src 
ENDM	
	
MACRO	VM_LVs	dest, src, off 
temp_ld	= offset off 
temp_ld	= temp_ld/3 
	DB	9, dest, src, temp_ld 
ENDM	
	
MACRO	VM_LVl	dest, src, off 
temp_ld	= offset off 
temp_ld	= temp_ld/3 
	DB	10, dest, src 
	DW	temp_ld 
ENDM	
	
MACRO	VM_LV_R	dest, src, off 
	DB	11, dest, src, off 
ENDM	
	
MACRO	VM_LG_R	dest, src 
	DB	27, dest, src 
ENDM	
	
MACRO	VM_BIND	const, src
	DB	29, const, src 
ENDM	
	
MACRO	VM_DEF	dest, const 
	DB	31, dest, const 
ENDM	
	
MACRO	VM_DENV	sym, val, env 
	DB	220, sym, val, env 
ENDM	
	
MACRO	VM_CLO	dest, lbl, nargs 
	local	x 
	DB	60, dest 
	DW	lbl-x 
	DB	nargs 
LABEL	x
ENDM	
	
MACRO	VM_LF_R	dest, src
	DB	63, dest, src 		; temporary instruction?
ENDM	
	
MACRO	VM_CAR	dest, src 
	DB	64, dest, src 
ENDM	
	
MACRO	VM_CDR	dest, src 
	DB	65, dest, src 
ENDM	
	
MACRO	VM_CAAR	dest, src 
	DB	66, dest, src 
ENDM	
	
MACRO	VM_CADR	dest, src 
	DB	67, dest, src 
ENDM	
	
MACRO	VM_CDAR	dest, src 
	DB	68, dest, src 
ENDM	
	
MACRO	VM_CDDR	dest, src 
	DB	69, dest, src 
ENDM	
	
MACRO	VM_CAAAR dest, src 
	DB	70, dest, src 
ENDM	
	
MACRO	VM_CAADR dest, src 
	DB	71, dest, src 
ENDM	
	
MACRO	VM_CADAR dest, src 
	DB	72, dest, src 
ENDM	
	
MACRO	VM_CADDR dest, src 
	DB	73, dest, src 
ENDM	
	
MACRO	VM_CDAAR dest, src 
	DB	74, dest, src 
ENDM	
	
MACRO	VM_CDADR dest, src 
	DB	75, dest, src 
ENDM	
	
MACRO	VM_CDDAR dest, src 
	DB	76, dest, src 
ENDM	
	
MACRO	VM_CDDDR dest, src 
	DB	77, dest, src 
ENDM	
	
MACRO	VM_CADDDR dest, src 
	DB	78, dest, src 
ENDM	
	
MACRO	VM_CONS	dest, car, cdr 
	DB	79, dest, car, cdr 
ENDM	
	
MACRO	VM_SCAR	dest, src 
	DB	20, dest, src 
ENDM	
	
MACRO	VM_SCDR	dest, src 
	DB	21, dest, src 
ENDM	
	
MACRO	VM_SVs	dest, src, off 
	DB	17, dest, src, offset off 
ENDM	
	
MACRO	VM_SVl	dest, src, off 
	DB	18, dest, src 
	DW	offset off 
ENDM	
	
MACRO	VM_SV_R	dest, src, off 
	DB	19, dest, src, off 
ENDM	
	
MACRO	VM_JMPs	LABEL 
	DB	32, label-$-1 
ENDM	
	
MACRO	VM_JMPl	LABEL 
	DB	33 
	DW	label-$-2 
ENDM	
	
MACRO	VM_JNLs	reg, LABEL 
	DB	34, reg, label-$-1 
ENDM	
	
MACRO	VM_JNLl	reg, LABEL 
	DB	35, reg 
	DW	label-$-2 
ENDM	
	
MACRO	VM_JTs	reg, LABEL 
	DB	36, reg, label-$-1 
ENDM	
	
MACRO	VM_JTl	reg, LABEL 
	DB	37, reg 
	DW	label-$-2 
ENDM	
	
MACRO	VM_JAs	reg, LABEL 
	DB	38, reg, label-$-1 
ENDM	
	
MACRO	VM_JAl	reg, LABEL 
	DB	39, reg 
	DW	label-$-2 
ENDM	
	
MACRO	VM_JNAs reg, LABEL 
	DB	40, reg, label-$-1 
ENDM	
	
MACRO	VM_JNAl reg, LABEL 
	DB	41, reg 
	DW	label-$-2 
ENDM	
	
MACRO	VM_CALL	label, dl_lvl, dl_heap 
	DB	48 
	DW	label-$-4 
	DB	dl_lvl, dl_heap 
ENDM	
	
MACRO	VM_CLTR	LABEL, dl_lvl, dl_heap 
	DB	49 
	DW	label-$-4 
	DB	dl_lvl, dl_heap 
ENDM	
	
MACRO	VM_CLCC	LABEL, dl_lvl, dl_heap 
	DB	50 
	DW	label-$-4 
	DB	dl_lvl, dl_heap 
ENDM	
	
MACRO	VM_CLCT	LABEL, dl_lvl, dl_heap 
	DB	51 
	DW	label-$-4 
	DB	dl_lvl, dl_heap 
ENDM	
	
MACRO	VM_CLCL	reg, nargs 
	DB	52, reg, nargs 
ENDM	
	
MACRO	VM_CLO?	dest 			; (closure? obj)
	DB	129, dest 
ENDM	
	
MACRO	VM_FLU?	dest 			; (fluid-bound? obj)
	DB	134, dest 
ENDM	
	
MACRO	VM_NUM?	dest			; (number? obj)
	DB	137, dest
ENDM

MACRO	VM_STR?	dest 			; (string? obj)
	DB	143, dest 
ENDM	
	
MACRO	VM_SYM?	dest 			; (symbol? obj)
	DB	144, dest 
ENDM	
	
MACRO	VM_NEG	dest 			; (minus n)
	DB	151, dest 
ENDM	
	
MACRO	VM_A2S	dest 			; (ascii->symbol n)
	DB	160, dest 
ENDM	
	
MACRO	VM_S2A	dest 			; (symbol->ascii sym)
	DB	161, dest 
ENDM	
	
MACRO	VM_ADD	dest, src 
	DB	80, dest, src 
ENDM	
	
MACRO	VM_ADDI	dest, imm 
	DB	81, dest, imm 
ENDM	
	
MACRO	VM_SUB	dest, src 
	DB	82, dest, src 
ENDM	
	
MACRO	VM_MUL	dest, src 
	DB	83, dest, src 
ENDM	
	
MACRO	VM_MULI	dest, imm 
	DB	84, dest, imm 
ENDM	
	
MACRO	VM_DIV	dest, src 
	DB	85, dest, src 
ENDM	
	
MACRO	VM_DIVI	dest, imm 
	DB	86, dest, imm 
ENDM	
	
MACRO	VM_MOD	dest, src 
	DB	88, dest, src 
ENDM	
	
MACRO	VM_JEQs	reg1, reg2, LABEL 
	DB	42, reg1, reg2, label-$-1 
ENDM	
	
MACRO	VM_JEQl	reg1, reg2, LABEL 
	DB	43, reg1, reg2 
	DW	label-$-2 
ENDM	
	
MACRO	VM_JNEs	reg1, reg2, LABEL 
	DB	44, reg1, reg2, label-$-1 
ENDM	
	
MACRO	VM_JNEl	reg1, reg2, LABEL 
	DB	45, reg1, reg2 
	DW	label-$-2 
ENDM	
	
MACRO	VM_EQ	n1, n2 
	DB	94, n1, n2 
ENDM	
	
MACRO	VM_NE	n1, n2 
	DB	97, n1, n2 
ENDM	
	
MACRO	VM_LT	n1, n2 
	DB	92, n1, n2 
ENDM	
	
MACRO	VM_GT	n1, n2 
	DB	95, n1, n2 
ENDM	
	
MACRO	VM_LE	n1, n2 
	DB	93, n1, n2 
ENDM	
	
MACRO	VM_GE	n1, n2 
	DB	96, n1, n2 
ENDM	
	
MACRO	VM_EQZ	dest 			; (=0 n)
	DB	146, dest 
ENDM	
	
MACRO	VM_LTZ	dest 			; (<0 n)
	DB	147, dest 
ENDM	
	
MACRO	VM_GTZ	dest 			; (>0 n)
	DB	148, dest 
ENDM	
	
MACRO	VM_ABS	dest 			; (abs n)
	DB	149, dest 
ENDM	
	
MACRO	VM_FLR	dest 			; (floor n)
	DB	152, dest 
ENDM	
	
MACRO	VM_FLT	dest 			; (float n)
	DB	150, dest 
ENDM	
	
MACRO	VM_GEN	dest 			; (gensym sym)
	DB	162, dest 
ENDM	
	
MACRO	VM_XPLD	dest 			; (explode sym)
	DB	163, dest 
ENDM	
	
MACRO	VM_MPLD	dest 			; (implode list)
	DB	164, dest 
ENDM	
	
MACRO	VM_LEN	dest 			; (length list)
	DB	165, dest 
ENDM	
	
MACRO	VM_LPR	dest 			; (last-pair list)
	DB	166, dest 
ENDM	
	
MACRO	VM_POP	dest 
	DB	24, dest 
ENDM	
	
MACRO	VM_PUSH	dest 
	DB	25, dest 
ENDM	
	
MACRO	VM_DROP	count 
	DB	26, count 
ENDM	
	
MACRO	VM_EXEC	code 
	DB	58, code 
ENDM	
	
MACRO	VM_EXIT				; restore (return from call)
	DB	59 
ENDM	
	
MACRO	VM_APLY	ftn, arg 		; apply funtion to args
	DB	56, ftn, arg 
ENDM	
	
MACRO	VM_ATR	ftn, arg 		; apply funtion to args-tail recursive
	DB	57, ftn, arg 
ENDM	
	
MACRO	VM_ACB dest 			; allocate code block
	DB	172, dest 
ENDM	
	
MACRO	VM_STC src, cb, offset		; store constant
	DB	173, src, cb, offset 
ENDM	
	
MACRO	VM_STB	src, cb, offset 	; store code byte
	DB	174, src, cb, offset 
ENDM	
	
MACRO	VM_OPP	file, mode 		; open I/O port
	DB	176, file, mode 
ENDM	
	
MACRO	VM_CLP	file 			; close I/O port
	DB	177, file 
ENDM	
	
MACRO	MV_PR1	dest, port 		; print s-expression
	DB	178, dest, port 
ENDM	
	
MACRO	VM_PRC	dest, port 		; print s-expression
	DB	179, dest, port 
ENDM	
	
MACRO	VM_PRT	dest, port 		; print s-expression
	DB	180, dest, port 
ENDM	
	
MACRO	VM_NL	port 			; print newline
	DB	181, port 
ENDM	
	
MACRO	VM_READ	dest 			; read s-expression
	DB	182, dest 
ENDM	
	
MACRO	VM_FASL	dest 			; fast load
	DB	191, dest 
ENDM	
	
MACRO	VM_HALT	errorcode		; return to MS-DOS
	DB	248, errorcode
ENDM	
	
MACRO	VM_GC				; garbage collect
	DB	249 
ENDM	
	
MACRO	VM_TIME				; display current time
	DB	250 
ENDM	
	
MACRO	VM_SRST				; scheme-reset
	DB	252 
ENDM	
	
MACRO	VM_CLEARREGS			; clear registers
	DB	253 
ENDM	
	
MACRO	VM_DBG				; begin debug mode
	DB	255 
ENDM	
	
