(define r1 '(-.0625 .5625 .5625 -.0625))
(define r2 '(-.18 .68 .68 -.18))
(define r3 '(.3 .1 .4 .2))
(define r4 '(.1 .4 .4 .1))

(define (f rule l)
  (apply + (map *
		rule
		(list (if (null? l) 0 (car l))
		      (if (null? (cdr l)) 0 (cadr l))
		      (if (null? (cddr l)) 0 (caddr l))
		      (if (null? (cdddr l)) 0 (cadddr l))))))
(define N0 (list 0 0 0 1 0 0))
(define (next rule l)
  (define (loop l)
    (if (null? (cdr l))
	'()
	(cons (cadr l)
	      (cons (f rule l)
		    (loop (cdr l))))))
  (loop (cons 0 l)))

(define (plot y)
  (define (make-x from by num)
    (if (= num 0)
	'()
	(cons from (make-x (+ from by) by (- num 1)))))
  (let ((x (make-x -3 (/ 6 (length y)) (length y))))
    (move-to (cons (car x) (car y)))
    (map (lambda (x y) (line-to (cons x y))) x y))
  (line-to '(3 . 0)))

(define (ig)
  (init-graph)
  (set-world! '(0 . 1) '(1 . 2))
  (set-world! '(-3 . 1) '(3 . -.5)))

(define (cg)
  (close-graph))

(define (iter rule n)
  (if (= n 0)
      n0
      (next rule (iter rule (- n 1)))))

