;;; -*-Scheme-*-
;;;
;;;	$Header: runmd.scm,v 13.91 87/10/24 16:38:55 GMT jinx Rel $
;;;
;;;	Copyright (c) 1987 Massachusetts Institute of Technology
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

;;;; CScheme Runtime System

(declare (usual-integrations))

(define system-global-environment (the-environment))
(define interrupt-mask-gc-ok 7)		;GC & Stack overflow only
(define interrupt-mask-none  0)		;Absolutely everything off
(define interrupt-mask-all   -1)	;Normal: all enabled

(define runtime-system
  (make-environment

(define :name "Runtime")
(define :version 13)
(define :modification 91)
(define :files)

(define runtime-identification		;RCS sets up this string.
  "$Header: runmd.scm,v 13.91 87/10/24 16:38:55 GMT jinx Rel $")

(define (:load)
  (let ((garbage-collector
	 (binary-fasload (cold-file-name (car cold-files-1)))))
    (scode-eval garbage-collector system-global-environment)
    (purify garbage-collector (cold-file-pure? (car cold-files-1))))
  (set! newline-char (vector-ref (microcode-identify) 5))
  (cold-load-loop (cdr cold-files-1))
  (set! cold-files-2
	(cons (cons (pathname-definition-filename) (cdar cold-files-2))
	      (cdr cold-files-2)))
  (cold-load-loop cold-files-2)
  (set! :files (map cold-file-name (append cold-files-1 cold-files-2)))
  ((access snarf-version microcode-system))
  ((access install interrupt-system))
  ((access install error-system))
  ((access reset! working-directory-package))
  (purify (get-fixed-objects-vector) false))

(define (cold-load-loop files)
  (if (not (null? files))
      (begin (cold-load-file (cold-file-name (car files))
			     (cold-file-pure? (car files))
			     system-global-environment)
	     (cold-load-loop (cdr files)))))

(define (cold-load-file filename pure? environment)
  (tty-write-char newline-char)
  (tty-write-string filename)
  (let ((expression (binary-fasload filename)))
    (tty-write-string " loaded")
    (purify expression pure?)
    (tty-write-string " purified")
    (scode-eval expression environment)
    (tty-write-string " evaluated")))

(define cold-file-name car)
(define (cold-file-pure? file) (cadr file))
(define newline-char)

(let-syntax ((define-primitive
	       (macro (name)
		 `(DEFINE ,name ,(make-primitive-procedure name)))))
  (define-primitive binary-fasload)
  (define-primitive tty-write-string)
  (define-primitive tty-write-char)
  (define-primitive microcode-identify))

(define cold-files-1
  '(("gc.bin" #T)			;The GC interface.

    ;; Microcode Description
    ("utabs.bin" #T)			;Microcode system.
    ("implmd.bin" #T)			;CScheme dependent items.

    ;; Basic Utilities
    ("boot.bin" #T)			;Most basic of primitives.
    ("fixart.bin" #T)			;Fixnum arithmetic.
    ("narith.bin" #T)			;Generic arithmetic.
    ("equals.bin" #T)			;Equality.
    ("list.bin" #T)			;Lists.
    ("vector.bin" #T)			;Object vectors.
    ("string.bin" #T)			;Strings.
    ("char.bin" #T)			;Characters.
    ("bitstr.bin" #T)			;Bit strings.
    ("wind.bin" #T)			;Dynamic winder (FLUID-LET).

    ;; SCode Abstraction
    ("sdata.bin" #T)			;Data field abstraction.
    ("scode.bin" #T)			;SCODE simple abstractions.
    ("scomb.bin" #T)			;SCODE Combinator abstractions.
    ("lambda.bin" #T)			;SCODE Lambda abstraction.
    ("scan.bin" #T)			;Scan out definitions.
    ("ustruc.bin" #T)			;Microcode data structures abstraction.

    ;; Stack Parser
    ("histry.bin" #T)			;History abstraction.
    ("stackp.bin" #T)			;Continuation parser machinery.
    ("spmd.bin" #T)			;CScheme stack parser

    ;; Syntax
    ("numpar.bin" #T)			;Parse characters -> numbers.
    ("numunp.bin" #T)			;Unparse numbers -> characters.
    ("parse.bin" #T)			;Parsing characters -> objects.
    ("unpars.bin" #T)			;Unparsing objects -> characters.
    ("syntax.bin" #T)			;S-expressions -> SCode.

    ;; Pathnames
    ("pathnm.bin" #T)			;Pathname abstraction.
    ))

(define pathname-definition-associations
  ;; This should be extended as more parsers become available.
  '(("unix" "unxpth.bin")
    ("vms" "vmspth.bin")))
    
(define (pathname-definition-filename)
  (cadr (or (assoc (microcode-identification-item 'OS-NAME-STRING)
		   pathname-definition-associations)
	    '("unknown" "unkpth.bin"))))

(define cold-files-2
  '(("pathmd.bin" #T)			;OS dependent pathname parsing.

    ;; I/O
    ("io.bin" #T)			;I/O primitives.
    ("input.bin" #F)			;
    ("output.bin" #F)			;
    ("keyint.bin" #T)			;Keyboard Interrupt Control.

    ;; Top level
    ("rep.bin" #T)			;Read-Eval-Print loop.
    ("repuse.bin" #T)			;REP User Interface.
    ("intrpt.bin" #T)			;Interrupt system.
    ("error.bin" #T)			;Error system.
    ("world.bin" #T)			;World (band) operations.
    ))

(define (finish-load)
  (set-working-directory-pathname!
   (pathname-directory-string
    (string->pathname
     ((make-primitive-procedure 'MICROCODE-TABLES-FILENAME)))))
  (let ((scode (map fasload extra-files)))
    (newline) (write-string "Purify")
    (purify (list->vector scode) true)
    (for-each (lambda (name scode)
		(newline) (write-string "Eval ") (write name)
		(scode-eval scode system-global-environment))
	      extra-files
	      scode))
  (set! :files (append :files extra-files))
  (add-system! microcode-system)
  (add-system! runtime-system)
  ((access install! gc-statistics-package))
  *the-non-printing-object*)

(define extra-files
  '(
    ;; Some important system integration tools.
    "events.bin"
    "system.bin"
    "sysclk.bin"
    "gcstat.bin"

    ;; Some nice things.
    "macros.bin"			;More special forms.
    "defstr.bin"			;Structure definition macro.
    "xlist.bin"				;More list operations.
    "hash.bin"				;Object hash and friends.
    "types.bin"				;Type system.
    "stypes.bin"			;Default system types.
    "crock.bin"				;A terrible crock -- CPH.
    "datime.bin"			;Date/Time.
    "msort.bin"				;Merge Sort
    "gensym.bin"			;Gensym.

    "sfile.bin"				;Simple file commands.
    "format.bin"			;Output Formatting.
    "unsyn.bin"				;Unsyntaxer.
    "pp.bin"				;Pretty Printer.

    ;; Debugging System
    "advice.bin"			;Advice (TRACE, BREAK).
    "comand.bin"			;Debug command loops.
    "where.bin"				;Environment inspector.
    "debug.bin"				;Continuation inspector.

    "emacs.bin"				;GNU Emacs interface.
    ))

;;; end RUNTIME-SYSTEM.
))

((access :load runtime-system))

(define user-initial-environment
  (make-environment))

(define user-initial-syntax-table
  (make-syntax-table system-global-syntax-table))

(define user-initial-prompt-string
  "]=>")

(define user-initial-prompt
  (standard-rep-prompt user-initial-prompt-string))

(define replace-rep!)

(let ()
  (define (warm-boot-loop rep)
    (warm-boot-loop
     (call-with-current-continuation
       (lambda (continuation)
	 (set! replace-rep! continuation)
	 ;; Kludge to prevent holding REP.
	 ((set! rep))))))
  (warm-boot-loop
    (lambda ()
      (make-rep user-initial-environment
		user-initial-syntax-table
		user-initial-prompt
		console-input-port
		console-output-port
		(lambda ()
		  (write-string "
Cold load finished.  Type

((access finish-load runtime-system))

to load the rest of the system."))))))