/* -*-C-*-

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* $Header: unknown.c,v 9.25 87/07/15 22:11:31 GMT cph Rel $

   Contains the operating system dependent primitives and routines
   that Scheme needs, written in portable C (most of them
   unimplemented).

   Mostly provided as a skeleton for users to implement their own operating
   system files.

   See unix.c and vms.c for possible implementations.

*/

/* Fixnum multiplication.  Portable code. */

#include "mul.c"

/* Binary file I/O Operations */

extern long Load_Data(), Write_Data();
extern Boolean Open_Dump_File(), Close_Dump_File();

static FILE *File_Handle;

Boolean
Open_Dump_File( Name, flag)
     Pointer Name;
     char *flag;
{
  File_Handle = fopen(Scheme_String_To_C_String( Name), flag);
  return (File_Handle != ((FILE *) NULL));
}

Boolean
Close_Dump_File()
{
  return (fclose(File_Handle) == 0);
}

long
Load_Data(Count, To_Where)
     long Count;
     char *To_Where;
{
  extern int fread();

  return (fread(To_Where, sizeof(Pointer), Count, File_Handle));
}

long
Write_Data( Count, From_Where)
     long Count;
     char *From_Where;
{
  extern int fwrite();

  return (fwrite(From_Where, sizeof( Pointer), Count, File_Handle));
}

/* File I/O Operations */

FILE *
OS_file_open( name, output_p)
     char *name;
     Boolean output_p;
{
  return (fopen( name, (output_p ? "w" : "r")));
}

Boolean
OS_file_close( stream)
     FILE *stream;
{
  return ((fclose( stream)) == 0);
}

Boolean
OS_file_eof_p( stream)
     FILE *stream;
{
  return (feof( stream));
}

/*** Could this be written using fseek? */

long
OS_file_length( stream)
     FILE *stream;
{
  Primitive_Error( ERR_EXTERNAL_RETURN);
}

/* Three-valued; Lisp may need this smartness someday:

     -1   Does not exist.
      0   Don't know.
      1   Exists.

   Kludgerous implementation should be improved by someone. */

int
OS_file_existence_test (name)
     char *name;
{
  FILE *test_stream;

  test_stream = (OS_file_open (name, false));
  if (test_stream == NULL)
    return (-1);
  else
    {
      OS_file_close (test_stream);
      return (1);
    }
}

long
OS_file_read_chars( stream, buffer, nchars)
     FILE *stream;
     char *buffer;
     long nchars;
{
  return (fread( buffer, 1, nchars, stream));
}

Boolean
OS_file_write_chars( stream, buffer, nchars)
     FILE *stream;
     char *buffer;
     long nchars;
{
  return (fwrite( buffer, 1, nchars, stream) == nchars);
}

/* Working directory. */

Pointer
OS_working_dir_pathname()
{
  return (NIL);
}

Boolean
OS_set_working_dir_pathname( name)
     char *name;
{
  Primitive_Error( ERR_EXTERNAL_RETURN);
}

/* File System Operations */

Boolean
OS_file_remove( name)
     char *name;
{
  return (false);
}

Boolean
OS_file_link_physical( old_name, new_name)
     char *old_name, *new_name;
{
  return (false);
}

Boolean
OS_file_link_symbolic( old_name, new_name)
     char *old_name, *new_name;
{
  return (false);
}

Boolean
OS_file_rename( old_name, new_name)
     char *old_name, *new_name;
{
  return (false);
}

/* This should use fread and fwrite to buffer. */

Boolean
OS_file_copy( source_name, destination_name)
     char *source_name, *destination_name;
{
  FILE *source, *dest;
  int c;

  if ((source = fopen( source_name, "r")) == NULL)
    return (false);

  if ((dest = fopen( destination_name, "w")) == NULL)
  { fclose(source);
    return (false);
  }

  while ((c = getc(source)) != EOF)
    putc(c, dest);

  fclose(source);
  fclose(dest);
  return (true);
}

Boolean
OS_directory_make( name)
     char *name;
{
  return (false);
}

Pointer
OS_directory_open( name)
     char *name;
{
  return (NIL);
}

Pointer
OS_directory_read()
{
  Primitive_Error( ERR_EXTERNAL_RETURN);
}

/* Terminal hacking. */


/* The following is provided only for other parts of the microcode (debug.c) */

extern int OS_tty_tyi();

int
OS_tty_tyi(immediate, interrupted)
     Boolean immediate, *interrupted;
{
  int the_char;

  if ((the_char = getchar()) == EOF)
    Microcode_Termination(TERM_EOF);

  *interrupted = false;
  return the_char;
}

/* The difference between these two procedures is that
   OS_tty_read_char is allowed to buffer characters, and thus allow
   input editing, for example, while OS_tty_read_char_immediate is
   supposed to return as soon as a character is typed.

   Here, the immediate version reduces to the "normal" version, since
   we don't know of any portable C way to guarantee unbuffered I/O.
 */

#define define_OS_tty_read_char( name, immediate)		\
char								\
name()								\
{								\
  int chr;							\
								\
  while (true)							\
    {								\
      Boolean Interrupted;					\
								\
      chr = OS_tty_tyi( (immediate), &Interrupted);		\
      if (Interrupted)						\
	{							\
	  if ((IntEnb & IntCode) != 0)				\
	    Primitive_Interrupt();				\
	}							\
      else							\
	return ((char) chr);					\
    }								\
}

define_OS_tty_read_char( OS_tty_read_char, false)
define_OS_tty_read_char( OS_tty_read_char_immediate, true)

void
OS_tty_write_char (chr)
     char chr;
{
  putc (chr, stdout);
  return;
}

Boolean
OS_tty_write_chars (string, string_length)
     char *string;
     long string_length;
{
  Boolean result;

  result = ((fwrite (string, 1, string_length, stdout)) == string_length);
  return (result);
}

void
OS_Flush_Output_Buffer()
{
  fflush (stdout);
}

/* Some of these return plausible arbitrary values. */

Boolean
OS_Clear_Screen()
{
  putchar('\f');
  return (true);
}

Boolean
OS_tty_move_cursor( x, y)
     long x, y;
{
  return (false);
}

Boolean
OS_tty_beep()
{
  putchar(BELL);
  return true;
}

void
OS_tty_newline()
{
  OS_tty_write_char ('\n');
  return;
}

Boolean
OS_tty_get_cursor (x, y)
     long *x, *y;
{
  *x = 0;
  *y = 0;
  return (false);
}

long
NColumns ()
{
  return (79);
}

long
NLines ()
{
  return (24);
}

Boolean
OS_Clear_To_End_Of_Line ()
{
  return (false);
}

Boolean
OS_Under_Emacs ()
{
  return (false);
}

/* System Clock */

long
OS_real_time_clock ()
{
  return 0;
}

long
System_Clock ()
{
  return 0;
}

void
Init_System_Clock ()
{
  return;
}

/* Time and dates. */

#define Date_Part(C_Name, Which)					\
int									\
C_Name()								\
{									\
  return -1;								\
}

Date_Part(OS_Current_Year, tm_year);
Date_Part(OS_Current_Month, tm_mon + 1);
Date_Part(OS_Current_Day, tm_mday);
Date_Part(OS_Current_Hour, tm_hour);
Date_Part(OS_Current_Minute, tm_min);
Date_Part(OS_Current_Second, tm_sec);

/* Timers (for timer interrupts) */

void
Clear_Int_Timer()
{
  fprintf(stderr, "\nClear_Int_Timer: not implemented.");
  return;
}

void
Set_Int_Timer(days, centi_seconds)
     long days, centi_seconds;
{
  fprintf(stderr, "\nSet_Int_Timer: not implemented.");
  return;
}

/* Keyboard interrupts. */

/* The arguments to OS_Clean_Interrupt_Channel are ignored,
   The possible modes are:
 */

#define UNTIL_MOST_RECENT_INTERRUPT_CHARACTER	0
#define MULTIPLE_COPIES_ONLY			1

Boolean
OS_Clean_Interrupt_Channel(mode, interrupt_char)
     int mode, interrupt_char;
{
  return true;
}

static char Int_Char;

int
OS_Get_Next_Interrupt_Character()
{
  int result;

  if (Int_Char == '\0')
    return -1;
  result = ((int) Int_Char);
  Int_Char = '\0';
  return result;
}

/* This procedure is supposed to return true if there is input pending
   to be read, false if there isn't, but will wait delay centiseconds.
 */   

Boolean
OS_read_char_ready_p( delay)
     long delay;
{
  return (false);
}

/* Interrupt handler.  To be installed on ^A if possible.
   Fix the h command, and the herald in OS_Init when interrupts
   are installed.
 */

#define INTERRUPT	1
#define REDO		2

#define CONTROL_B       'B'
#define CONTROL_G       'G'
#define CONTROL_P       'P'
#define CONTROL_X       'X'
#define CONTROL_A	'A'
#define CONTROL_U	'U'
#define CONTROL_F	'F'
#define CONTROL_M	'M'

long 
Ask_Me()
{
  char command;

  putchar(BELL);
  putchar('\n');
Loop:
  printf("Interrupt character (? for help): ");
  command =  getchar();
  switch (command)
  { case 'B':
    case 'b': Int_Char = CONTROL_B; break;

    case 'D':
    case 'd': putchar('\n');
	      Handle_Debug_Flags();
	      goto exit_gracefully;
    case 'T':
    case 't': putchar('\n');
	      Back_Trace();
	      goto exit_gracefully;

    case 'G':
    case 'g': Int_Char = CONTROL_G; break;

    case 'P':
    case 'p':
    case 'U':
    case 'u': Int_Char = CONTROL_U; break;

    case 'F':
    case 'f':
    case 'X':
    case 'x': Int_Char = CONTROL_X; break;

    case 'H':
    case 'h': printf("\nThe following control characters are available at");
              printf("\nany time in Scheme:\n");
              printf("\n^A: interactive choice of interrupt");
              printf("\n<returning to Scheme>\n");
              goto exit_gracefully;

    case 'Q':
    case 'q':
	      putchar('\n');
	      Microcode_Termination(TERM_HALT);

    case '\f': OS_Clear_Screen(); goto exit_gracefully;

    case 'I':
    case 'i': 	 printf("gnored.\n");
exit_gracefully: return REDO;

    default: putchar('\n');
             printf("B: Enter a breakpoint loop\n");
             printf("D: Debugging: change interpreter flags\n");
             printf("F or X: Abort to current REP loop\n");
             printf("G: Goto to top level read-eval-print (REP) loop\n");
	     printf("H: Print information about interrupt characters\n");
             printf("I: Ignore interrupt request\n");
             printf("P or U: Up to previous (lower numbered) REP loop\n");
             printf("Q: Quit instantly, killing Scheme\n");
             printf("T: Stack trace\n");
             printf("^L: Clear the screen\n");
             goto Loop;
  }
  IntCode |= INT_Character;
  New_Compiler_MemTop();
  return INTERRUPT;
}

Boolean
Restartable_Exit()
{
  return (false);
}

/* Initializes OS dependent information for Scheme */

void 
OS_Re_Init()
{
  return;
}

void 
OS_Init()
{
  OS_Name = "unknown";
  OS_Variant = NULL;
  printf("MIT Scheme, Unknown operating system version\n");
#if true
  printf("There are no Scheme interrupt characters.\n");
#else
  printf("^AH (CTRL-A, then H) shows help on interrupt keys.\n");
#endif
  Int_Char = '\0';
  /* Split out to correspond to UNIX where we can suspend and continue */
  OS_Re_Init();
  return;
}

void 
OS_Quit()
{
  return;
}

