/* -*-C-*-

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* $Header: random.c,v 9.36 87/04/16 02:28:16 GMT jinx Rel $
 *
 * Totally random primitives.  Most should go away.
 *
 */

#include "scheme.h"
#include "primitive.h"

/* Mapping between the internal and external representations of
   primitives, return addresses, external primitives, etc.
 */

/* (MAP-CODE-TO-MACHINE-ADDRESS TYPE-CODE VALUE-CODE)
   For return codes and primitives, this returns the internal
   representation of the return address or primitive address given
   the external representation.  Currently in CScheme these two are
   the same.  In the 68000 assembly version the internal
   representation is an actual address in memory.
*/
Built_In_Primitive(Prim_Map_Code_To_Address, 2,
		   "MAP-CODE-TO-MACHINE-ADDRESS", 0x93)
{
  long Code, Offset;
  Primitive_2_Args();

  Arg_1_Type(TC_FIXNUM);
  Arg_2_Type(TC_FIXNUM);
  Code = Get_Integer(Arg1);
  Offset = Get_Integer(Arg2);
  switch (Code)
  { case TC_RETURN_CODE:
      if (Offset > MAX_RETURN_CODE)
	Primitive_Error(ERR_ARG_2_BAD_RANGE);
      break;

    case TC_PRIMITIVE:
      if (Offset > MAX_PRIMITIVE)
	Primitive_Error(ERR_ARG_2_BAD_RANGE);
      break;

    default: Primitive_Error(ERR_ARG_1_BAD_RANGE);
  }
  return Make_Non_Pointer(Code, Offset);
}

/* (MAP-MACHINE-ADDRESS-TO-CODE TYPE-CODE ADDRESS)
   This is the inverse operation for MAP_CODE_TO_ADDRESS.
   Given a machine ADDRESS and a TYPE-CODE (either return code or
   primitive) it finds the number for the external representation
   for the internal address.
*/
Built_In_Primitive(Prim_Map_Address_To_Code, 2,
		   "MAP-MACHINE-ADDRESS-TO-CODE", 0x90)
{
  long Code, Offset;
  Primitive_2_Args();

  Arg_1_Type(TC_FIXNUM);
  Code = Get_Integer(Arg1);
  Arg_2_Type(Code);
  Offset = Get_Integer(Arg2);
  switch (Code)
  { case TC_RETURN_CODE:
      if (Offset > MAX_RETURN_CODE)
        Primitive_Error(ERR_ARG_2_BAD_RANGE);
      break;

    case TC_PRIMITIVE:
      if (Offset > MAX_PRIMITIVE)
        Primitive_Error(ERR_ARG_2_BAD_RANGE);
      break;

    default: 
      Primitive_Error(ERR_ARG_1_BAD_RANGE);
  }
  return Make_Unsigned_Fixnum(Offset);
}

/* (PRIMITIVE-PROCEDURE-ARITY INTERNAL-PRIMITIVE)
   Given the internal representation of a primitive (in CScheme the
   internal and external representations are the same), return the
   number of arguments it requires.
*/
Built_In_Primitive(Prim_Map_Prim_Address_To_Arity, 1,
		 "PRIMITIVE-PROCEDURE-ARITY", 0x96)
{
  extern long external_primitive_to_arity();
  extern long primitive_to_arity();
  long Prim_Num, answer;
  Primitive_1_Arg();

  Prim_Num = Get_Integer(Arg1);

  if (Type_Code(Arg1) != TC_PRIMITIVE_EXTERNAL)
  {
    Arg_1_Type(TC_PRIMITIVE);
    answer = primitive_to_arity(Prim_Num);
    if (answer < 0)
      Primitive_Error(ERR_ARG_1_BAD_RANGE);
    return Make_Unsigned_Fixnum(answer);
  }

  /* External primitives here */

  answer = external_primitive_to_arity(Prim_Num);
  if (answer >= 0)
    return Make_Unsigned_Fixnum(answer);

  if (Prim_Num > (MAX_EXTERNAL_PRIMITIVE + NUndefined()))
    Primitive_Error(ERR_ARG_1_BAD_RANGE);

  return NIL;
}

/* Playing with non marked vectors. */

/* (NON-MARKED-VECTOR-CONS LENGTH)
   Creates a non-marked vector of the specified LENGTH.  The
   contents of such a vector are not seen by the garbage collector.
   There are no ordinary operations which can be performed on
   non-marked vectors, but the SYS_VECTOR operations can be used
   with care.
   [This primitive appears to be a fossil of days gone by.]
*/
Built_In_Primitive(Prim_Non_Marked_Vector_Cons, 1, "NON-MARKED-VECTOR-CONS", 0x31)
{
  long Length;
  Primitive_1_Arg();

  Arg_1_Type(TC_FIXNUM);
  Length = Get_Integer(Arg1);
  Primitive_GC_If_Needed(Length + 1);
  *Free = Make_Non_Pointer(TC_MANIFEST_NM_VECTOR, Length);
  Free += (Length + 1);
  return Make_Pointer(TC_NON_MARKED_VECTOR, Free - (Length + 1));
}

/* (INSERT-NON-MARKED-VECTOR TO-GC-VECTOR N FROM-GC-VECTOR)
   This primitive performs a side-effect on the TO-GC-VECTOR.  Both
   TO- and FROM-GC-VECTOR must be of the garbage collector type
   vector (i.e. vectors, strings, non-marked vectors, bignums,
   etc.).  The FROM-GC-VECTOR is inserted in the middle of
   TO-GC-VECTOR, preceded by a non-marked vector header.  The
   insertion begins at the Nth position of the vector with the
   non-marked header.  Notice that this is really an "overwrite"
   rather than an insertion, since the length of the TO-GC-VECTOR
   does not change and the data which was formerly in the part of
   the vector now occupied by FROM-GC-VECTOR and its header has
   been lost.  This primitive was added for the use of certain
   parts of the compiler and runtime system which need to make
   objects that have an internal part which is "hidden" from the
   garbage collector. The value returned is TO-GC-VECTOR.
*/
Built_In_Primitive(Prim_Insert_Non_Marked_Vector, 3,
		   "INSERT-NON-MARKED-VECTOR!", 0x19)
{
  Pointer *To, *From;
  long Index, NM_Length, Length, i;
  Primitive_3_Args();

  Arg_1_GC_Type(GC_Vector);
  Arg_2_Type(TC_FIXNUM);
  Arg_3_GC_Type(GC_Vector);
  Length = Vector_Length(Arg1);
  NM_Length = Vector_Length(Arg3);
  Range_Check(Index, Arg2, 0, (Length - 1), ERR_ARG_2_BAD_RANGE);
  if ((Length - Index) <= NM_Length)
    Primitive_Error(ERR_ARG_3_BAD_RANGE);
  From = Nth_Vector_Loc(Arg3, VECTOR_TYPE);
  To = Nth_Vector_Loc(Arg1, VECTOR_DATA + Index);
  for (i = 0; i <= NM_Length; i++)
  {
    *To++ = *From++;
  }
  return Arg1;
}

/* Multiprocessor scheduling primitive */

extern Pointer Get_Work();

Built_In_Primitive(Prim_Get_Work, 1, "GET-WORK", 0x8)
{
  Primitive_1_Arg();

  return Get_Work(Arg1);
}

#ifndef butterfly
#ifdef COMPILE_FUTURES
Pointer Get_Work(Arg1)
     Pointer Arg1;
{
  Pointer The_Queue, Queue_Head, Result, The_Prim;

  /* This gets this primitive's code which is in the expression register. */
  The_Prim = Fetch_Expression();
  The_Queue = Get_Fixed_Obj_Slot(The_Work_Queue);
  if (The_Queue != NIL) Queue_Head = Vector_Ref(The_Queue, CONS_CAR);
  if ((The_Queue==NIL) || (Queue_Head==NIL))
    if (Arg1 == NIL)
    {
      printf("\nNo work available, but some has been requested!\n");
      Microcode_Termination(TERM_EXIT);
    }
    else
    {
      Pop_Primitive_Frame(1);
     Will_Push(2*(STACK_ENV_EXTRA_SLOTS+1) + 1 + CONTINUATION_SIZE);
      Push(NIL);	/* Upon return, no hope if there is no work */
      Push(The_Prim);
      Push(STACK_FRAME_HEADER+1);
      Store_Expression(NIL);
      Store_Return(RC_INTERNAL_APPLY);
      Save_Cont();
      Push(Arg1);
      Push(STACK_FRAME_HEADER);
     Pushed();
      longjmp(*Back_To_Eval, PRIM_APPLY);
  }
  Result = Vector_Ref(Queue_Head, CONS_CAR);
  Queue_Head = Vector_Ref(Queue_Head, CONS_CDR);
  Vector_Set(The_Queue, CONS_CAR, Queue_Head);
  if (Queue_Head==NIL) Vector_Set(The_Queue, CONS_CDR, NIL);
  return Result;
}

#else /* #ifdef COMPILE_FUTURES */

Pointer Get_Work(Arg1)
     Pointer Arg1;
{
  Primitive_Error(ERR_UNIMPLEMENTED_PRIMITIVE);
  /*NOTREACHED*/
}

#endif /* #ifdef COMPILE_FUTURES */
#endif /* #ifndef butterfly */
