;;; -*- SCHEME -*-

(define typical-package
  (make-environment
    ;; Print self method
    (DEFINE (:PRINT-SELF)
      (unparse-with-brackets (lambda () (display "The TYPICAL environment"))))))

(define (typical-load file)
  (pure-load (string-append "/u/kwh/programs/typical/" file ".bin")
	     typical-package))

;;; Load type implementation:
(typical-load "kernel")
(typical-load "synthetic")
(typical-load "direct")
(typical-load "indirect")
(typical-load "inductive")
(typical-load "composite")
(typical-load "datatypes")
(typical-load "metatypes")
;;; Test type implementation:
(typical-load "test-suite")
((access test-suite typical-package))
;;; Load TYPICAL utilities:
(typical-load "metafns")
(typical-load "maptypes")
(typical-load "index")
(typical-load "df")
(typical-load "props")
(typical-load "ef")
(typical-load "commands")
;;; Just for MIT Scheme
(typical-load "scode")

(%ge typical-package)

