;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/typical/kernel"))


;;; This file extends the TYPICAL inspector to understand C-Scheme SCODE.

(define compound-procedures
  (type "Compound Procedures" simple-type compound-procedure? procedures))

(add-type-property! procedure-lambda compound-procedures)
(set-property-printer! procedure-lambda
		       (lambda (v) (printout $NL "Lambda Definition:")
			       (pp v (current-output-port) 'as-code)))

(define (mapfree fcn exp bindings)
  (cond ((variable? exp) (if (not (memq (variable-name exp) bindings)) (fcn exp)))
	((lambda? exp) (mapfree fcn (lambda-body exp) (append (lambda-bound exp) bindings)))
	((combination? exp)
	 (mapfree fcn (combination-operator exp) bindings)
	 (map (lambda (arg) (mapfree fcn arg bindings))  (combination-operands exp)))
	((conditional? exp)
	 (mapfree fcn (conditional-predicate exp) bindings)
	 (mapfree fcn (conditional-consequent exp) bindings)
	 (mapfree fcn (conditional-alternative exp) bindings))
	((sequence? exp)
	 (for-each (lambda (x) (mapfree fcn x bindings)) (sequence-actions exp)))
	((disjunction? exp)
	 (mapfree fcn (disjunction-predicate exp) bindings)
	 (mapfree fcn (disjunction-alternative exp) bindings))
	((definition? exp)
	 (mapfree fcn (definition-value exp) bindings))
	((assignment? exp) (fcn (assignment-variable exp))
	 (mapfree fcn (assignment-value exp) bindings))))

(define (make-variable-property-function var)
  (define (var-accessor p)
    (let ((env  (procedure-environment p)))
      (if (lexical-unreferenceable? env var) (%undefined)
	  (lexical-reference env var))))
  (define (var-mutator p f)
    (let ((env  (procedure-environment p)))
      (if (lexical-unbound? env var) (error "Unbound variable!" var)
	  (lexical-assignment env var
			      (f (if (lexical-unassigned? env var) (%undefined)
				     (lexical-reference env var)))))))
  ((modifier mutator) var-accessor var-mutator)
  (set-property-printer! var-accessor
			 (lambda (v) (printout $NL "Binding of " var ":   " v)))
  var-accessor)

(define make-variable-property (simple-cache make-variable-property-function))

(define (make-variables-visible procedure)
  (mapfree (lambda (v) (add-unique-property!
			procedure (make-variable-property (variable-name v))))
	   (procedure-lambda procedure) ()))

(set-procedure-description! make-variables-visible 
			    "Look up free variables on classified procedures.")
(add-daemon! make-variables-visible compound-procedures)


	  
	 

