;;; -*- Mode:  Scheme; Syntax: Common-lisp; Package: SCHEME-USER -*-

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/typical/kernel"))



;;;; Examples over Z+

(define one+ (type "ONE+" lisp-application-type (procedure! 1+ integers integers)))
(define (num-= pair)
  (and (list? pair) (list? (cdr pair))
       (number? (car pair)) (number? (cadr pair))
       (apply =? pair)))
(define (num-> pair)
  (and (list? pair) (list? (cdr pair))
       (number? (car pair)) (number? (cadr pair))
       (apply >? pair)))
(define m=n
  (type "m=n" simple-type num-= (cross-product integers integers)))
(define m>n
  (type "m>n" simple-type num-> (cross-product integers integers)))

(define (setup-Z+)
  (define (add-integer-examples n)
    (record-example! n numbers)
    (if (> n 0) (add-integer-examples (-1+ n))))
  (message $NL "Setting up Z+; generating integer examples....")
  (add-integer-examples 20)
  (message $NL "Finished setting up integer examples; making relations....")
  (for-each focus! (list one+ m=n m>n))
  (message $NL "Classifying relations....")
  (classify one+) (classify m=n) (classify m>n))
