/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

#import <objc/Object.h>

@interface PrefAgent:Object
{
NXZone	*agentZone;
    id	prefPanel;
    id	theBox;
    id	buttonMatrix;
    id	win0;
    id	options1Matrix;
    id	onErrorMatrix;
    id	win1;
    id	options2Matrix;
    id	win2;
    id	deField;
    id	formsBrowser;
    id	formsField;
    id	win3;
    id	dialectMatrix;
    id	executableForm;
    id	parametersBox;
    id	parametersField;
}

+ new;

- activateAgent:sender;
- buttonClicked:sender;
- selectPrefs:sender;

@end

@interface PrefAgent (Localization)

#define LocalString(key, value) doLocalString(key, value)

- loadLocalNib:(const char *)nibFile owner:(id)owner fromZone:(NXZone *)zone;
- loadLocalMainMenu:(const char *)nibFile;
- localImage:(const char *)imageFile fromZone:(NXZone *)zone;

const char *doLocalString(const char *, const char *);

@end

@interface PrefAgent (Client0)

#define CLIENT0		0
#define EVALALLAT	0
#define COMMMENTOUTAT	1
#define INSERTERRSAT	2
#define TRANSCRIPTAT	3
#define AUTOSCROLLAT	4
#define CONFCLOSEAT	5
#define CONFQUITAT	6
#define KEEPBACKUPAT	7

- (BOOL)evaluateAll;
- (BOOL)commentOutput;
- (BOOL)insertErrors;
- (BOOL)transcriptMode;
- (BOOL)autoScroll;
- (BOOL)confirmOnClose;
- (BOOL)confirmOnQuit;
- (BOOL)keepBackupCopy;
- (int)errorAbort;
- setConfirmOnClose:(BOOL)aBool;

@end

@interface PrefAgent (Client1)

#define CLIENT1		1
#define DBLCLICKAT	0
#define AUTOINDENTAT	1
#define MATCHPARENAT	2
#define FORMATPASTEAT	3

- (BOOL)dblClickMatch;
- (BOOL)autoindent;
- (BOOL)matchParens;
- (BOOL)formatAfterPaste;

@end

@interface PrefAgent (Client2)

#define CLIENT2		2

- formsButtonClicked:sender;
- formsBrowserClick:sender;

- (BOOL)isSpecialForm:(const char *)aString;
- (int)deForSpecialForm:(const char *)aString;
- (int)keywordListVersion;

@end

@interface PrefAgent (Client3)

#define CLIENT3		3
#define SICPDIALECT	0
#define MITDIALECT	1
#define MITDIALECTCOMP	2
#define OTHERDIALECT	3

- dialectChosen:sender;

- (int)schemeDialect;
- (char *)executable;
- (char *)parameters;

@end

@interface PrefAgent (NoClient)

#import <appkit/graphics.h>

- setInterFrame:(const NXRect *)r;
- getInterFrame:(NXRect *)r;
- setInterFont:(id)aFont;
- (char *)interFont;
- (float)interFontSize;
- getDocOrigin:(NXPoint *)p;
- getDocOffset:(NXPoint *)p;
- (BOOL)reverseVideo;
- (BOOL)useSpecialCursors;
- getGraphicsSize:(NXSize *)s;
- getGraphicsTolerance:(NXSize *)s;

@end

@interface Keyword:Object
{
  char	*keyword;
   int	distelems;
}

- init;
- initTo:(char *)aString with:(int)anInt;
- free;
- (char *)keyword;
- (int)distinguishedElems;
- setKeyword:(char *)aString;
- setDistElems:(int)anInt;

@end
