(define (sierpinsky n)

  (define h 2)
  (define offset -128)
  (define size 256)

  (define (line x1 y1 x2 y2)
    (position-pen x1 y1)
    (draw-line-to x2 y2))

  (define (sierp j)

    (let* ((h (/ (/ size 4) (expt 2 j)))
           (current-x (+ offset (* h 2)))
           (current-y (+ offset h)))

      (define (draw d l)
        (let ((inc-x (case d ((0 1 7) l) ((3 4 5) (- l)) (else 0)))
              (inc-y (case d ((1 2 3) l) ((5 6 7) (- l)) (else 0))))
          (line current-x current-y
                (+ current-x inc-x) (- current-y inc-y))
         (set! current-x (+ current-x inc-x))
          (set! current-y (- current-y inc-y))
          #f))

      (define (s k i)
        (if (> k 0)
          (let ((k (- k 1)))
            (s k (modulo i       8)) (draw (modulo (- i 1) 8) h)
            (s k (modulo (+ i 6) 8)) (draw (modulo i       8) (* h 2))
            (s k (modulo (+ i 2) 8)) (draw (modulo (+ i 1) 8) h)
            (s k (modulo i       8)))))

      (define (ss k)
        (s k 0) (draw 7 h)
        (s k 6) (draw 5 h)
        (s k 4) (draw 3 h)
        (s k 2) (draw 1 h))

      (ss j)))

  (let loop ((j 0))
    (if (<= j n)
      (begin
        (sierp j)
        (loop (+ j 1))))))
