(##declare
  (extended-bindings)
  (not safe)
  (not autotouch)
  (block)
  (fixnum))

;------------------------------------------------------------------------------

(let ((v ##argv))
  (let ((n (##vector-length v)))
    (if (##fixnum.= n 1)

      (begin
        (##display "Gambit (v2.0)" ##stdout #f)
        (##newline ##stdout)

        (let* ((repl-info (##make-vector 4 #f))
               (dyn-bindings (##list (##cons '##REPL-INFO repl-info))))
          (##call-with-current-continuation
            (lambda (abort)
              (##vector-set! repl-info 0 ##stdin)
              (##vector-set! repl-info 1 ##stdout)
              (##vector-set! repl-info 2 0)
              (##vector-set! repl-info 3 (##cons abort '()))
              (##dynamic-bind
                dyn-bindings
                (lambda ()
                  (let ((init (##open-input-file ".init.scm")))
                    (if init (begin (##close-port init) (##load ".init.scm" #f))
                      (let ((init (##open-input-file "~/.init.scm")))
                        (if init (begin (##close-port init) (##load "~/.init.scm" #f)))))))))))

        (##repl))

      (let loop1 ((i 1))
        (if (##fixnum.< i n)
          (let ((port (##open-input-string (##vector-ref v i))))
            (let loop2 ()
              (let ((expr (##read port)))
                (if (##not (##eof-object? expr))
                  (let ((val (##eval-global expr)))
                    (##write val ##stdout #t)
                    (##newline ##stdout)
                    (loop2)))))
            (##close-port port)
            (loop1 (##fixnum.+ i 1))))))))

;------------------------------------------------------------------------------
