(##declare
  (standard-bindings)
  (extended-bindings)
  (not safe)
  (not autotouch)
  (block)
  (fixnum))

(##declare
  (namespace "c#")
  (namespace ""
    not boolean? eqv? eq? equal? pair? cons car cdr set-car! set-cdr!
    caar cadr cdar cddr caaar caadr cadar caddr cdaar cdadr cddar cdddr
    caaaar caaadr caadar caaddr cadaar cadadr caddar cadddr cdaaar cdaadr
    cdadar cdaddr cddaar cddadr cdddar cddddr null? list? list length
    append reverse list-ref memq memv member assq assv assoc symbol?
    symbol->string string->symbol number? complex? real? rational?
    integer? exact? inexact? = < > <= >= zero? positive? negative? odd?
    even? max min + * - / abs quotient remainder modulo gcd lcm numerator
    denominator floor ceiling truncate round rationalize exp log sin cos
    tan asin acos atan sqrt expt make-rectangular make-polar real-part
    imag-part magnitude angle exact->inexact inexact->exact number->string
    string->number char? char=? char<? char>? char<=? char>=? char-ci=?
    char-ci<? char-ci>? char-ci<=? char-ci>=? char-alphabetic?
    char-numeric? char-whitespace? char-upper-case? char-lower-case?
    char->integer integer->char char-upcase char-downcase string?
    make-string string string-length string-ref string-set! string=?
    string<? string>? string<=? string>=? string-ci=? string-ci<?
    string-ci>? string-ci<=? string-ci>=? substring string-append vector?
    make-vector vector vector-length vector-ref vector-set! procedure?
    apply map for-each call-with-current-continuation call-with-input-file
    call-with-output-file input-port? output-port? current-input-port
    current-output-port open-input-file open-output-file close-input-port
    close-output-port eof-object? read read-char peek-char write display
    newline write-char

    load
  ))

;------------------------------------------------------------------------------

(set! open-input-file* ##open-input-file)

(let ((v ##argv))

  (define (string->object str)
    (let ((port (##open-input-string str)))
      (let ((expr (##read port)))
        (##close-port port)
        expr)))

  (let ((n (vector-length v)))
    (if (> n 1)

      (let ((args (map string->object (cddr (##vector->list v)))))

        (set! pvm-opts? (not (memq 'no-pvm-opts args)))

        (let ((x (memq 'intr-latency args)))
          (let ((i (if (and x (pair? (cdr x)) (integer? (cadr x)))
                     (cadr x)
                     10)))
            (set! intr-latency i)))

        (let ((x (memq 'interrupt-period args)))
          (let ((i (if (and x (pair? (cdr x)) (integer? (cadr x)))
                     (cadr x)
                     90)))
            (set! interrupt-period i)))

        (let ((x (memq 'interrupt-head args)))
          (let ((i (if (and x (pair? (cdr x)) (integer? (cadr x)))
                     (cadr x)
                     15)))
            (set! interrupt-head i)))

        (let ((x (memq 'interrupt-tail args)))
          (let ((i (if (and x (pair? (cdr x)) (integer? (cadr x)))
                     (cadr x)
                     15)))
            (set! interrupt-tail i)))

        (let ((x (memq 'lazy-task-kind args)))
          (let ((k (if (and x (pair? (cdr x)))
                     (cadr x)
                     'MESSAGE-PASSING-LTQ)))
            (set! lazy-task-kind k)))

        (let ((x (memq 'program-prefix args)))
          (let ((l (if (and x (pair? (cdr x))) (cadr x) '())))
            (set! program-prefix l)))

        (let ((x (memq 'program-suffix args)))
          (let ((l (if (and x (pair? (cdr x))) (cadr x) '())))
            (set! program-suffix l)))

        (apply cf (vector-ref v 1) 'm68000 args))

      (begin
        (##display "Gambit (v2.0)" ##stdout #f)
        (##newline ##stdout)

        (let* ((repl-info (##make-vector 4 #f))
               (dyn-bindings (##list (##cons '##REPL-INFO repl-info))))
          (##call-with-current-continuation
            (lambda (abort)
              (##vector-set! repl-info 0 ##stdin)
              (##vector-set! repl-info 1 ##stdout)
              (##vector-set! repl-info 2 0)
              (##vector-set! repl-info 3 (##cons abort '()))
              (##dynamic-bind
                dyn-bindings
                (lambda ()
                  (let ((init (##open-input-file ".init.scm")))
                    (if init (begin (##close-port init) (##load ".init.scm" #f))
                      (let ((init (##open-input-file "~/.init.scm")))
                        (if init (begin (##close-port init) (##load "~/.init.scm" #f)))))))))))

        (##repl)))))

;------------------------------------------------------------------------------
