/* Definition of data structures */

/*---------------------------------------------------------------------------*/

/* global variable */

struct global_rec { SCM_obj value; long jump_adr; };
typedef struct global_rec *GLOBAL_PTR;


/* trap trampolines and global jump trampolines */

struct trap_rec { short jmp; long adr; short buf; };
typedef struct trap_rec *TRAP_PTR;
typedef short *TRAMP_PTR;


/* system state description */

struct sstate_rec {
  GLOBAL_PTR globals;
  TRAMP_PTR tramps;
  TRAP_PTR traps;
  char *const_bot, *const_bptr, *const_tptr, *const_top;
  char *program_filename;
  long nb_ofiles;
  struct { long len; char *ptr; long stats_bot, stats_top; }
    ofile[MAX_NB_OFILES];
  long stats_on;
  long stats_start_time, stats_stop_time;
  long nb_stats;
  long stats_offsets[MAX_NB_STATS];
  long profiling;
  long debug;
  };

typedef struct sstate_rec *SSTATE_PTR;


/* processor state description */

struct pstate_rec {
  long intr_flag;                       /*  0: interrupt flag                */

  long **ltq_tail;                      /*  1: allocation ptr, grows down    */
  long **ltq_head;                      /*  2: steal ptr, grows down         */
  long **deq_tail;                      /*  3: allocation ptr, grows up      */
  long **deq_head;                      /*  4: steal ptr, grows up           */
  long **q_bot;                         /*  5: bottom of area for ltq & deq  */
  long **q_top;                         /*  6: top of area                   */

  long *stack_lim;                      /*  7: allocation limit              */
  long *stack_ptr;                      /*  8: allocation ptr, grows down    */
  long *stack_bot;                      /*  9: bottom of stack area          */
  long *stack_top;                      /* 10: top of stack area             */

  char *heap_old;                       /* 11: ptr to old space              */
  char *heap_lim;                       /* 12: allocation limit              */
  char *heap_ptr;                       /* 13: allocation ptr, grows down    */
  char *heap_bot;                       /* 14: bottom of Scheme heap         */
  char *heap_top;                       /* 15: top of Scheme heap            */
  char *heap_mid;                       /* 16: middle of Scheme heap         */

  char *closure_lim;                    /* 17: closure alloc limit           */
  char *closure_ptr;                    /* 18: closure alloc ptr, grows down */

  long workq_lockO, workq_lockV;        /* 19: work queue OWNER/VISITOR lock */
  SCM_obj workq_tail;                   /* 21: tail of work queue            */
  SCM_obj workq_head;                   /* 22: head of work queue            */

  SCM_obj current_task;                 /* 23: pointer to current task       */
  SCM_obj parent_ret;                   /* 24: parent continuation ret adr   */
  SCM_obj parent_frame;                 /* 25: parent continuation frame     */
  SCM_obj current_dyn_env;              /* 26: current dynamic environment   */
  SCM_obj temp_task;                    /* 27: preallocated task             */
  SCM_obj bos_ret;                      /* 28: bottom of stack return adr    */

  long steal_scan;                      /* 29: scan ptr for stealing         */
  long steal_lockO, steal_lockV;        /* 30: steal OWNER/VISITOR lock      */

  SCM_obj response;                     /* 32: response from victim          */
  SCM_obj thief;                        /* 33: thief processor               */

  long intr_other;                      /* 34: true if any of these true:    */
  long intr_barrier;                    /* 35: barrier interrupt flag        */
  long intr_timer;                      /* 36: interval timer interrupt flag */
  long intr_user;                       /* 37: user interrupt flag           */
  long intr_io;                         /* 38: io interrupt flag             */

  void (*flush_writes)();               /* 39: procedure to flush mem writes */

  long temp1, temp2;                    /* 40: temporary values              */

  long heap_margin;                     /* 42: size of heap margin zone      */
  long stack_margin;                    /* 43: size of stack margin zone     */
  long heap_max_margin;                 /* 44: max heap margin               */
  long stack_max_margin;                /* 45: max stack margin              */

  SCM_obj count1, count2;               /* 46: counters for statistics       */

  SCM_obj processor_storage[56-48];     /* 48: processor Scheme storage      */

  long reserved2[59-56];                /* 56: reserved for future use       */

  long *elog_bot;                       /* 59: bottom of event log area      */
  long *elog_top;                       /* 60: top of event log area         */
  long *elog_ptr;                       /* 61: allocation ptr, grows down    */

  SCM_obj id;                           /* 62: processor number              */
  SCM_obj nb_processors;                /* 63: number of processors          */

  struct pstate_rec *ps[MAX_NB_PROC];   /* 64: table of all processors       */
  struct pstate_rec *steal_ps[MAX_NB_PROC];/* randomized table of processors */

  char *emul_code_bot;                  /* bottom of emulation code          */
  char *emul_code_top;                  /* top of emulation code             */
  char *emul_code_ptr;                  /* allocation ptr, grows up          */

  char *local_heap_bot;                 /* bottom of local heap              */
  char *local_heap_top;                 /* top of local heap                 */
  char *local_heap_ptr;                 /* allocation ptr, grows up          */

  long *stats_counters;                 /* ptr to statistics counters        */

  short *prof_bot;                      /* bottom of profiling counters      */
  short *prof_top;                      /* top of profiling counters         */

  long sync0, sync1, sync2;             /* used for barrier sync             */
  long sync0_msg1, sync1_msg1, sync2_msg1;
  long sync0_msg2, sync1_msg2, sync2_msg2;

  long cpu_times[2];
  long stats_cpu_times[2];

  long temp[4];

  IEEE_FP64 *fp_ptr;
  IEEE_FP80 fp0, fp_cmp1, fp_cmp2;
  };

typedef struct pstate_rec *PSTATE_PTR;


#define table            ((long)sstate->const_bot-0x8000L)
#define table_offset(x)  ((long)(x)-(long)sstate->const_bot+0x8000L)
#define pstate_offset(x) ((long)(x)-(long)pstate)


/*---------------------------------------------------------------------------*/

/* global data structures */

extern SSTATE_PTR sstate;  /* pointer to system state           */
extern PSTATE_PTR pstate;  /* pointer to this processor's state */

/*---------------------------------------------------------------------------*/
