(declare (usual-integrations))

(define-macro (+ . l)
  (case (length l)
    ((0) '0)
    ((1) (car l))
    ((2) `(fix:+ ,(car l) ,(cadr l)))
    (else `(fix:+ ,(car l) (+ ,@(cdr l))))))

(define-macro (* . l)
  (case (length l)
    ((0) '1)
    ((1) (car l))
    ((2) `(fix:* ,(car l) ,(cadr l)))
    (else `(fix:* ,(car l) (* ,@(cdr l))))))

(define-macro (- . l)
  (case (length l)
    ((1) `(fix:- 0 ,(car l)))
    ((2) `(fix:- ,(car l) ,(cadr l)))
    (else `(fix:- ,(car l) (- ,@(cdr l))))))

(define-macro (quotient x y)
  `(fix:quotient ,x ,y))

(define-macro (remainder x y)
  `(fix:remainder ,x ,y))

(define-macro (=  x y) `(eq? ,x ,y))
(define-macro (<  x y) `(fix:< ,x ,y))
(define-macro (>  x y) `(fix:< ,y ,x))
(define-macro (<= x y) `(not (fix:< ,y ,x)))
(define-macro (>= x y) `(not (fix:< ,x ,y)))
