/* @(#)stacks.h	1.4 12/9/89 */

#ifndef _STACKS_H
#define _STACKS_H

typedef struct stack_s {
    Obj *min, *cur, *max;
    int size;
} Stack_t, *Stack;

/* size of the stack */
#define stackSize(stack) ((stack)->size)

/* current stack pointer */
#define stackPtr(stack) ((stack)->cur)

/* bottom of the stack */
#define stackBot(stack) ((stack)->min)

/* past top of the stack (not current position) */
#define stackTop(stack) ((stack)->max)

/* pop item from stack */
#define stackPop(stack) (*(--((stack)->cur)))

/* peek at item on top of stack */
#define stackPeek(stack) ((stack)->cur[-1])

/* address of top num items on stack */
#define stackAddr(stack, num) ((stack)->cur - (num))

/* adjust stack downward by num items (does not check for over/under flow) */
#define stackAdj(stack, num) ((stack)->cur -= (num))

/* FALSE if stack is not empty */
#define stackEmpty(stack) ((stack)->min == (stack)->cur)

/* TRUE if the stack cannot hold x more items */
#define stackLimit(stack, x) ((stack)->cur + (x) >= (stack)->max)

/* Push item without checking for overflow (use only when you know that
 * you have enough stack space). */
#define stackPushAlways(item, stack) (*((stack)->cur++) = item)

#ifdef __STDC__

/* return a new stack that can hold size items */
extern Stack stackNew(int size);

/* push item on stack (fails if stack overflows) */
extern void stackPush(Obj item, Stack stack);

#else

extern Stack stackNew();
extern void stackPush();

#endif /* defined(__STDC__) */

#endif /* !defined(_STACKS_H) */
