/* @(#)Proc.h	1.7 2/23/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _PROC_H
#define _PROC_H

	/* procedures */

/* proc instance */
typedef struct procInst_s {
    basicInst_t inherit;
    char *name;
    unsigned short numargs;
} procInst_t, *procInst;

/* proc status flags */
#define OPTARG		BIT(0)	/* last arg is list of args or nil */
#define STABLE		BIT(1)	/* procedure's local frame is constant */
#define LEAF		BIT(2)	/* procedure has no local procedures */
#define TRACE_ENTRY	BIT(3)	/* trace on entry and exit */
#define TRACE_EXIT	BIT(4)
#define INTERNAL	BIT(5)	/* internal definition */

extern basicClass_t protoProc;
#define Proc ((Class)&protoProc)

	/* primitives */

/* prim instance */
typedef struct primInst_s {
    procInst_t inherit;
    F_OBJ cfunc;
} primInst_t, *primInst;

extern basicClass_t protoPrim;
#define Prim ((Class)&protoPrim)

#ifdef __STDC__

/* Make a new primitive for func and bind it to name in env (assumes name is
 * a statically (or permanently) allocated string). */
extern Obj newPrim(F_OBJ alloc, char *name, F_OBJ func, Obj env, int status,
		   int numargs);

#else

extern Obj newPrim();

#endif /* __STDC__ */

	/* special forms */

/* special form instance */
typedef struct specialInst_s {
    procInst_t inherit;
    F_VOID compiler;
} specialInst_t, *specialInst;

extern basicClass_t protoSpecial;
#define Special ((Class)&protoSpecial)

#ifdef __STDC__

/* Register a special form compiler for expressions of the form (name arg ...)
 * (name is assumed to be a statically (or permanently) allocated string). */
extern Obj newSpecial(F_OBJ alloc, char *name, F_VOID comp, int status,
		      int numargs);

#else

extern Obj newSpecial();

#endif /* __STDC__ */

	/* lambdas (user defined procedures) */

/* user instance */
typedef struct userInst_s {
    procInst_t inherit;
    unsigned short numfixed;
    Obj code, frame;
} userInst_t, *userInst;

extern basicClass_t protoUser;
#define User ((Class)&protoUser)

#define objCode(proc) DATA((proc), code, userInst)
#define objFormals(proc) DATA(objCode((proc)), locals, codevecInst)

#ifdef __STDC__

/* return a new local frame for proc */
extern Obj objFrame(Obj proc);

/* create a new user procedure */
extern Obj newUser(F_OBJ alloc, int numfixed, int numargs, int status,
		   Obj code, Obj parent);

#else

extern Obj objFrame();
extern Obj newUser();

#endif /* __STDC__ */

#endif /* _PROC_H */
