/* @(#)File.h	1.10 2/12/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#ifndef _FILE_H
#define _FILE_H

/* file status flags */
#define PUSHBACK   BIT(0)
#define QUERY      BIT(1)
#define MORE       BIT(2)
    
/* file instance */
typedef struct fileInst_s {
    basicInst_t inherit;
    FILE *file;
    struct par_info_s *par;
} fileInst_t, *fileInst;

#define objFile(st) DATA((st), file, fileInst)
#define objState(st) (DATA((st), par, fileInst)->state)
#define objText(st) (DATA((st), par, fileInst)->text)

extern basicClass_t protoFile;
#define File ((Class)&protoFile)

#ifdef __STDC__

/* make a file object out of a file ptr
 *
 * File objects are really only necessary for input streams.
 * prompt is the prompt string.
 * more is the prompt when input is not complete.
 * writeonly TRUE if the file will only be used for writing. */
extern Obj newFile(F_OBJ alloc, FILE *file, Boolean writeonly);

/* reset the parsing state of file */
extern void fileReset(Obj file);

/* close file */
extern void fileClose(Obj file);

#else

extern Obj newFile();
extern void fileReset();
extern void fileClose();

#endif /* __STDC__ */

#endif /* _FILE_H */
