;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/bfloat.scm ...                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 18:21:07 1993                          */
;*    Last change :  Mon Mar 14 08:43:00 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    L'infernal trippotage des floats                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_bfloat
   (foreign (obj format_float (obj obj) "format_float"))
   (export  (inline int_of_float x)
	    (inline float_of_int x)
	    (inline ~float x)
	    (inline +float x y)
	    (inline -float x y)
	    (inline *float x y)
	    (inline /float x y)
	    (inline =float x y)
	    (inline <>float x y)
	    (inline <float x y)
	    (inline >float x y)
	    (inline <=float x y)
	    (inline >=float x y)
	    (inline exp_float x)
	    (inline log_float x)
	    (inline sqrt_float x)
	    (inline power_float x y)
	    (inline sin_float x)
	    (inline cos_float x)
	    (inline tan_float x)
	    (inline asin_float x)
	    (inline acos_float x)
	    (inline atan_float x)
	    (inline atan2_float x y)
	    (inline float_of_string x)))

;*---------------------------------------------------------------------*/
;*    int_of_float ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (int_of_float x)
   (flonum->fixnum x))

;*---------------------------------------------------------------------*/
;*    float_of_int ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (float_of_int x)
   (fixnum->flonum x))

;*---------------------------------------------------------------------*/
 ;*    ~float ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (~float x)
   (negfl x))

;*---------------------------------------------------------------------*/
;*    +float ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (+float x y)
   (+fl x y))

;*---------------------------------------------------------------------*/
;*    -float ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (-float x y)
   (-fl x y))

;*---------------------------------------------------------------------*/
;*    *float ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (*float x y)
   (*fl x y))

;*---------------------------------------------------------------------*/
;*    /float ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (/float x y)
   (/fl x y))

;*---------------------------------------------------------------------*/
;*    =float ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (=float x y)
   (=fl x y))

;*---------------------------------------------------------------------*/
;*    <>float ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (<>float x y)
   (not (=fl x y)))

;*---------------------------------------------------------------------*/
;*    =<float ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (<float x y)
   (<fl x y))

;*---------------------------------------------------------------------*/
;*    >float ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (>float x y)
   (>fl x y))

;*---------------------------------------------------------------------*/
;*    <=float ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (<=float x y)
   (<=fl x y))

;*---------------------------------------------------------------------*/
;*    >=float ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (>=float x y)
   (>=fl x y))

;*---------------------------------------------------------------------*/
;*    exp_float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (exp_float x)
   (expfl x))

;*---------------------------------------------------------------------*/
;*    log_float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (log_float x)
   (logfl x))

;*---------------------------------------------------------------------*/
;*    sqrt_float ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (sqrt_float x)
   (sqrtfl x))

;*---------------------------------------------------------------------*/
;*    power_float ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (power_float x y)
   (exptfl x y))

;*---------------------------------------------------------------------*/
;*    sin_float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (sin_float x)
   (sinfl x))

;*---------------------------------------------------------------------*/
;*    cos_float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (cos_float x)
   (cosfl x))

;*---------------------------------------------------------------------*/
;*    tan_float ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (tan_float x)
   (tanfl x))

;*---------------------------------------------------------------------*/
;*    asin_float ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (asin_float x)
   (asinfl x))

;*---------------------------------------------------------------------*/
;*    acos_float ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (acos_float x)
   (acosfl x))

;*---------------------------------------------------------------------*/
;*    atan_float ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (atan_float x)
   (atanfl x))

;*---------------------------------------------------------------------*/
;*    atan_float ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (atan2_float x y)
   (atanfl x y))

;*---------------------------------------------------------------------*/
;*    float_of_string ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (float_of_string x)
   (string->real x))



   

