;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_filename
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (check_suffix_88@filename x1)
    (2-53-check_suffix_88@filename x1 x2)
    (chop_suffix_96@filename x1)
    (2-39-chop_suffix_96@filename x1 x2)
    current_dir_name_124@filename
    (concat_228@filename x1)
    (2-115-concat_228@filename x1 x2)
    (is_absolute_255@filename x1)
    (slash_pos_240@filename x1)
    (basename_226@filename x1)
    (dirname_229@filename x1)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(begin
  (define check_suffix_88@filename
    (lambda (x1)
      (lambda (x2)
        (2-53-check_suffix_88@filename x1 x2))))
 (define 2-53-check_suffix_88@filename
    (lambda (x1 x2)
      (and (>=fx (string-length x1) (string-length x2))
           (tree_equal
             (((sub_string_61@fstring x1)
               (-fx (string-length x1) (string-length x2)))
              (string-length x2))
             x2))))
)
(begin
  (define chop_suffix_96@filename
    (lambda (x1)
      (lambda (x2)
        (2-39-chop_suffix_96@filename x1 x2))))
 (define 2-39-chop_suffix_96@filename
    (lambda (x1 x2)
      (((sub_string_61@fstring x1) 0)
       (-fx (string-length x1) (string-length x2)))))
)
(define current_dir_name_124@filename #".")
(begin
  (define concat_228@filename
    (lambda (x1)
      (lambda (x2) (2-115-concat_228@filename x1 x2))))
 (define 2-115-concat_228@filename
    (lambda (x1 x2)
      (let ((x3 (-fx (string-length x1) 1)))
        (if (or (<fx x3 0) (eq? (string-ref x1 x3) #\/))
          ((^_54@fstring x1) x2)
          ((^_54@fstring x1) ((^_54@fstring #"/") x2))))))
)
(define is_absolute_255@filename
  (lambda (x1)
    (or (and (>=fx (string-length x1) 1)
             (tree_equal
               (((sub_string_61@fstring x1) 0) 1)
               #"/"))
        (or (and (>=fx (string-length x1) 2)
                 (tree_equal
                   (((sub_string_61@fstring x1) 0) 2)
                   #"./"))
            (and (>=fx (string-length x1) 3)
                 (tree_equal
                   (((sub_string_61@fstring x1) 0) 3)
                   #"../"))))))

(define slash_pos_240@filename
  (lambda (x1)
    (letrec ((x2 (lambda (x3)
                   (if (<fx x3 0)
                     (raise 'not_found_4@exc)
                     (if (eq? (string-ref x1 x3) #\/)
                       x3
                       (x2 (-fx x3 1)))))))
      (x2 (-fx (string-length x1) 1)))))

(define basename_226@filename
  (lambda (x1)
    (let* ((handler-top1001 current_handler)
           (:-d.1002 (unspecified)))
      (labels
        ((try1003
           (:-d.1002)
           (begin
             (get-the-continuation :-d.1002)
             (if (eq? #t #f) (try1003 (try1003 (try1003 1))))
             (if :-d.1002
               (let ((x2 (+fx (slash_pos_240@filename x1) 1)))
                 (((sub_string_61@fstring x1) x2)
                  (-fx (string-length x1) x2)))
               current_handler))))
        (let ((x2 (try1003 :-d.1002)))
          (set! current_handler handler-top1001)
          (if (=fx *try* 1)
            (begin
              (set! *try* 0)
              (labels
                ((staticfail1004 () (raise x2)))
                (case (caml-extensible-constr-tag x2)
                  ((not_found_4@exc) x1)
                  (else (staticfail1004)))))
            x2))))))

(define dirname_229@filename
  (lambda (x1)
    (if (tree_equal x1 #"/")
      x1
      (let* ((handler-top1006 current_handler)
             (:-d.1007 (unspecified)))
        (labels
          ((try1008
             (:-d.1007)
             (begin
               (get-the-continuation :-d.1007)
               (if (eq? #t #f) (try1008 (try1008 (try1008 1))))
               (if :-d.1007
                 (((sub_string_61@fstring x1) 0)
                  (slash_pos_240@filename x1))
                 current_handler))))
          (let ((x2 (try1008 :-d.1007)))
            (set! current_handler handler-top1006)
            (if (=fx *try* 1)
              (begin
                (set! *try* 0)
                (labels
                  ((staticfail1009 () (raise x2)))
                  (case (caml-extensible-constr-tag x2)
                    ((not_found_4@exc) #".")
                    (else (staticfail1009)))))
              x2)))))))

