;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.1/Camloo/ldefine.scm ...             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 27 16:44:16 1993                          */
;*    Last change :  Wed Apr 20 14:20:35 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La compilation des defines.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module Ldefine
   (include "Camloo/var.sch")
   (import  llambda
	    var
	    lconst
	    module
	    generate
	    misc)
   (export (Pset_global exp tl? cp)))

;*---------------------------------------------------------------------*/
;*    Pset_global ...                                                  */
;*---------------------------------------------------------------------*/
(define (Pset_global exp tl? cp)
   (match-case (cdr exp)
      (((Pset_global (qualifiedident ?module ?name)) (?value))
       (let* ((global (define-global name module))
	      (bvalue (llambda value #f '() #f)))
	  (if (not tl?)
	      ;; on n'est pas au top-level
	      (begin
		 (remember-unspecified-var! global)
		 `(set! ,global ,bvalue))
	      (begin
		 (if (or (not (pair? bvalue))
			 (not (eq? (car bvalue) 'lambda)))
		     `(define ,global ,bvalue)
		     (let ((curry (curryfied-lambda bvalue)))
			(if (=fx (car curry) 1)
			    (begin
			       (global-function?-set! global #t)
			       (global-arity-set! global (cadr curry))
			       `(define ,global ,bvalue))
			    (let* ((new-fun-name (curryfied-name
						  global
						  (car curry)))
				   (new-fun     (define-global new-fun-name
						   module)))
			       (global-function?-set! global  #t)
			       (global-function?-set! new-fun #t)
			       (global-arity-set!     new-fun (cadr curry))
			       (global-arity-set!     global  (list
							       (car
								(cadr
								 curry))))
			       `(begin
				   (define ,global
				      ,(let loop ((args (cadr curry)))
					  (if (null? args)
					      `(,new-fun ,@(cadr curry))
					      `(lambda (,(car args))
						  ,(loop (cdr args))))))
				   (define ,new-fun
				      (lambda ,(cadr curry)
					 ,(caddr curry))))))))))))
      (else
       (error "camloo" "Illegal `Pset_global' form" exp))))

;*---------------------------------------------------------------------*/
;*    curryfied-lambda ...                                             */
;*---------------------------------------------------------------------*/
(define (curryfied-lambda value)
   (let loop ((arity 0)
	      (args  '())
	      (value value))
      (match-case value
	 ((lambda (?a) ?body)
	  (loop (+fx arity 1) (cons a args) body))
	 ((begin (lambda (?a) ?body))
	  (loop (+fx arity 1) (cons a args) body))
	 (else
	  (list arity (reverse! args) value)))))

;*---------------------------------------------------------------------*/
;*    curryfied-name ...                                               */
;*---------------------------------------------------------------------*/
(define (curryfied-name global arity)
   (string->symbol (string-append (integer->string arity)
				  "-"
				  (integer->string
				   (get-hash-number (string-upcase
						     (symbol->string
						      (shape global)))))
				  "-"
				  (if (string? (global-name global))
				      (global-name global)
				      (symbol->string (global-name global))))))

