;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/tag.scm ...                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 18 13:37:00 1993                          */
;*    Last change :  Sun Feb 13 11:36:48 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les fonctions Bigloo qui manipulent les tags                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_tag
   (foreign (include "value-bigloo.h")
	    (include "CAMLClib/fail.h")
            (define int OUT_OF_MEMORY_EXN     "OUT_OF_MEMORY_EXN")
            (define int SYS_ERROR_EXN         "SYS_ERROR_EXN")
            (define int FAILURE_EXN           "FAILURE_EXN")
            (define int INVALID_EXN           "INVALID_EXN")
            (define int END_OF_FILE_EXN       "END_OF_FILE_EXN")
            (define int ZERO_DIVIDE_EXN       "ZERO_DIVIDE_EXN")
            (define int BREAK_EXN             "BREAK_EXN")
            (define int NOT_FOUND_EXN         "NOT_FOUND_EXN")
            (define int UNIX_ERROR_EXN        "UNIX_ERROR_EXN")
            (define int GRAPHIC_FAILURE_EXN   "GRAPHIC_FAILURE_EXN")
            (define int PARSE_FAILURE_EXN     "PARSE_FAILURE_EXN")
	    (define bint Num_tags             "Num_tags")
	    (define bint No_scan_tag          "No_scan_tag")
	    (define bint Scan_tag             "Scan_tag")
	    (define bint Closure_tag          "Closure_tag")
	    (define bint String_tag           "String_tag")
	    (define bint Double_tag           "Double_tag")
	    (define bool c-obj_is_block (obj) "Is_block"))
   (import  (__caml_constr "Llib/constr.scm"))
   (export  (tag-of value)))

;*---------------------------------------------------------------------*/
;*    tag-of ...                                                       */
;*---------------------------------------------------------------------*/
(define (tag-of value)
   (cond
      ((and (may-be-an-extensible-constr? value)
	    (caml-extensible-constr? value))
       (case (caml-extensible-constr-tag value)
	  ((out_of_memory@exc)
	   OUT_OF_MEMORY_EXN)
	  ((sys_error@sys)
	   SYS_ERROR_EXN)
	  ((failure@exc)
	   FAILURE_EXN)
	  ((invalid_argument@exc)
	   INVALID_EXN)
	  ((end_of_file@io)
	   END_OF_FILE_EXN)
	  ((division_by_zero@exc)
	   ZERO_DIVIDE_EXN)
	  ((break@sys)
	   BREAK_EXN)
	  ((not_found@exc)
	   NOT_FOUND_EXN)
	  ((parse_failure@stream)
	   PARSE_FAILURE_EXN)
	  ((parse_error@stream)
	   PARSE_FAILURE_EXN)
	  (else
	   -1)))
      ((integer? value)
       Num_tags)
      ((cnst? value)
       No_scan_tag)
      ((string? value)
       String_tag)
      ((char? value)
       Num_tags)
      ((real? value)
       Double_tag)
      ((procedure? value)
       Closure_tag)
      (else
       Scan_tag)))
	    
