;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/sys.scm ...                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 17:05:24 1993                          */
;*    Last change :  Mon Jan 17 09:36:15 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    System interface                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_sys
   (foreign (include "signal.h")
	    (include "caml-bigloo.h")
            (obj c-sys_open  (obj obj obj) "sys_open")
	    (obj c-sys_close (obj)         "sys_close")
	    (obj c-sys_exit  (obj)         "bigloo_exit")
	    (obj c-sys_error ()            "sys_error")
	    (define int s_irall_56@sys     "SYS__S_IRALL")
	    (define int s_iwall_219@sys    "SYS__S_IWALL"))
   (import  (__caml_handle "Llib/handle.scm"))
   (export  command_line_240@sys
	    interactive_191@sys
	    (inline c-sys_remove s)
	    (inline c-sys_rename a b)
	    (inline c-sys_getenv s)
	    (c-sys_chdir d)
	    (c-sys_catch_break flag)))
  
;*---------------------------------------------------------------------*/
;*    command_line ...                                                 */
;*---------------------------------------------------------------------*/
(define command_line_240@sys command_line_240@sys)

;*---------------------------------------------------------------------*/
;*    interactive ...                                                  */
;*---------------------------------------------------------------------*/
(define interactive_191@sys #f)

;*---------------------------------------------------------------------*/
;*    c-sys_remove ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-sys_remove s)
   (delete-file s))

;*---------------------------------------------------------------------*/
;*    c-sys_rename ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-sys_rename a b)
   (rename-file a b))

;*---------------------------------------------------------------------*/
;*    c-sys_getenv ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (c-sys_getenv s)
   (getenv s))
   
;*---------------------------------------------------------------------*/
;*    c-sys_chdir ...                                                  */
;*---------------------------------------------------------------------*/
(define (c-sys_chdir dirname)
   (if (not (=fx (chdir dirname) 0))
       (c-sys_error)
       '#<0000>))

;*---------------------------------------------------------------------*/
;*    c-sys_catch_break ...                                            */
;*---------------------------------------------------------------------*/
(define (c-sys_catch_break flag)
   (if flag
       (signal SIGINT (lambda (x) (raise 'break@sys)))
       (signal SIGINT c-sys_exit)))
