;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_int
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (min_84@int x1)
    (2-156-min_84@int x1 x2)
    (max_25@int x1)
    (2-211-max_25@int x1 x2)
    (abs_186@int x1)
    (lnot_59@int x1)
    string_of_int_188@int))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(begin
  (define min_84@int
    (lambda (x1)
      (lambda (x2) (2-156-min_84@int x1 x2))))
 (define 2-156-min_84@int
    (lambda (x1 x2) (if (<=fx x1 x2) x1 x2)))
)
(begin
  (define max_25@int
    (lambda (x1)
      (lambda (x2) (2-211-max_25@int x1 x2))))
 (define 2-211-max_25@int
    (lambda (x1 x2) (if (>=fx x1 x2) x1 x2)))
)
(define abs_186@int
  (lambda (x1) (if (<fx x1 0) (negfx x1) x1)))

(define lnot_59@int
  (lambda (x1) (bit-xor x1 -1)))

(define string_of_int_188@int
  ((lambda (x1) (lambda (x2) (c-format_int x1 x2)))
   #"%ld"))

(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
