;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/contrib0.0/libunix/Llib/unix.scm ...           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jan 11 17:31:46 1994                          */
;*    Last change :  Tue Jan 11 19:40:09 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ce fichier definit les fonctions qui sont referencees dans le    */
;*    fichier de la distribution standard `contrib/libunix/unix.mli'   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_unix
   (foreign
    (obj c-unix_error_message (obj)              "unix_error_message")
    (obj c-unix_environment   (obj)              "unix_environment")
    (obj c-unix_execv (obj obj)                  "unix_execv")
    (obj c-unix_execve (obj obj)                 "unix_execve")
    (obj c-unix_execvp (obj obj)                 "unix_execvp")
    (obj c-unix_fork (obj)                       "unix_fork")
    (obj c-unix_wait (obj)                       "unix_wait")
    (obj c-unix_waitopt (obj)                    "unix_waitopt")
    (obj c-unix_waitpid (obj obj)                "unix_waitpid")
    (obj c-unix_getpid (obj)                     "unix_getpid")
    (obj c-unix_getppid (obj)                    "unix_getppid")
    (obj c-unix_nice (obj)                       "unix_nice")
    (obj c-unix_open (obj obj obj)               "unix_open")
    (obj c-unix_close (obj)                      "unix_close")
    (obj c-unix_read (obj obj obj obj)           "unix_read")
    (obj c-unix_write (obj obj obj obj)          "unix_write")
    (obj c-channel_descriptor (obj)              "channel_descriptor")
    (obj c-unix_lseek (obj obj obj)              "unix_lseek")
    (obj c-unix_truncate (obj obj)               "unix_truncate")
    (obj c-unix_ftruncate (obj obj)              "unix_ftruncate")
    (obj c-unix_stat (obj)                       "unix_stat")
    (obj c-unix_lstat (obj)                      "unix_lstat")
    (obj c-unix_fstat (obj)                      "unix_fstat")
    (obj c-unix_rename (obj obj)                 "unix_rename")
    (obj c-unix_link (obj obj)                   "unix_link")
    (obj c-unix_chmod (obj obj)                  "unix_chmod")
    (obj c-unix_fchmod (obj obj)                 "unix_fchmod")
    (obj c-unix_chown (obj obj obj)              "unix_chown")
    (obj c-unix_fchown (obj obj obj)             "unix_fchown")
    (obj c-unix_umask (obj)                      "unix_umask")
    (obj c-unix_access (obj obj)                 "unix_access")
    (obj c-unix_fcntl_int (obj obj obj)          "unix_fcntl_int")
    (obj c-unix_fcntl_ptr (obj obj obj)          "unix_fcntl_ptr")
    (obj c-unix_mkdir (obj obj)                  "unix_mkdir")
    (obj c-unix_chdir (obj)                      "unix_chdir")
    (obj c-unix_rmdir (obj)                      "unix_rmdir")
    (obj c-unix_opendir (obj)                    "unix_opendir")
    (obj c-unix_readdir (obj)                    "unix_readdir")
    (obj c-unix_rewinddir (obj)                  "unix_rewinddir")
    (obj c-unix_closedir (obj)                   "unix_closedir")
    (obj c-unix_pipe (obj)                       "unix_pipe")
    (obj c-unix_dup (obj)                        "unix_dup")
    (obj c-unix_dup2 (obj obj)                   "unix_dup2")
    (obj c-unix_symlink (obj obj)                "unix_symlink")
    (obj c-unix_readlink (obj)                   "unix_readlink")
    (obj c-unix_mkfifo (obj obj)                 "unix_mkfifo")
    (obj c-unix_ioctl_int (obj obj obj)          "unix_ioctl_int")
    (obj c-unix_ioctl_ptr (obj obj obj)          "unix_ioctl_ptr")
    (obj c-unix_select (obj obj obj obj)         "unix_select")
    (obj c-unix_lockf (obj obj obj)              "unix_lockf")
    (obj c-unix_kill (obj obj)                   "unix_kill")
    (obj c-unix_pause (obj)                      "unix_pause")
    (obj c-unix_time (obj)                       "unix_time")
    (obj c-unix_gmtime (obj)                     "unix_gmtime")
    (obj c-unix_localtime (obj)                  "unix_localtime")
    (obj c-unix_alarm (obj)                      "unix_alarm")
    (obj c-unix_sleep (obj)                      "unix_sleep")
    (obj c-unix_times (obj)                      "unix_times")
    (obj c-unix_utimes (obj obj obj)             "unix_utimes")
    (obj c-unix_getuid (obj)                     "unix_getuid")
    (obj c-unix_geteuid (obj)                    "unix_geteuid")
    (obj c-unix_setuid (obj)                     "unix_setuid")
    (obj c-unix_getgid (obj)                     "unix_getgid")
    (obj c-unix_getegid (obj)                    "unix_getegid")
    (obj c-unix_setgid (obj)                     "unix_setgid")
    (obj c-unix_getgroups (obj)                  "unix_getgroups")
    (obj c-unix_getlogin (obj)                   "unix_getlogin")
    (obj c-unix_getpwnam (obj)                   "unix_getpwnam")
    (obj c-unix_getgrnam (obj)                   "unix_getgrnam")
    (obj c-unix_getpwuid (obj)                   "unix_getpwuid")
    (obj c-unix_getgrgid (obj)                   "unix_getgrgid")
    (obj c-unix_inet_addr_of_string (obj)        "unix_inet_addr_of_string")
    (obj c-unix_string_of_inet_addr (obj)        "unix_string_of_inet_addr")
    (obj c-unix_socket (obj obj obj)             "unix_socket")
    (obj c-unix_socketpair (obj obj obj)         "unix_socketpair")
    (obj c-unix_accept (obj)                     "unix_accept")
    (obj c-unix_bind (obj obj)                   "unix_bind")
    (obj c-unix_connect (obj obj)                "unix_connect")
    (obj c-unix_listen (obj obj)                 "unix_listen")
    (obj c-unix_shutdown (obj obj)               "unix_shutdown")
    (obj c-unix_recv (obj obj obj obj obj)       "unix_recv")
    (obj c-unix_recvfrom (obj obj obj obj obj)   "unix_recvfrom")
    (obj c-unix_send (obj obj obj obj obj)       "unix_send")
    (obj c-unix_sendto (obj obj obj obj obj obj) "unix_sendto")
    (obj c-unix_gethostname (obj)                "unix_gethostname")
    (obj c-unix_gethostbyname (obj)              "unix_gethostbyname")
    (obj c-unix_gethostbyaddr (obj)              "unix_gethostbyaddr")
    (obj c-unix_getprotobyname (obj)             "unix_getprotobyname")
    (obj c-unix_getprotobynumber (obj)           "unix_getprotobynumber")
    (obj c-unix_getservbyname (obj obj)          "unix_getservbyname")
    (obj c-unix_getservbyport (obj obj)          "unix_getservbyport")
    (obj c-unix_tcgetattr (obj)                  "unix_tcgetattr")
    (obj c-unix_tcsetattr (obj obj obj)          "unix_tcsetattr")
    (obj c-unix_tcsendbreak (obj obj)            "unix_tcsendbreak")
    (obj c-unix_tcdrain (obj)                    "unix_tcdrain")
    (obj c-unix_tcflush (obj obj)                "unix_tcflush")
    (obj c-unix_tcflow (obj obj)                 "unix_tcflow")))
	   
