;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.0/Camloo/main.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 27 13:16:44 1993                          */
;*    Last change :  Fri Feb 11 15:26:06 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le main du compilateur back->bigloo                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module main
   (main main)
   (import init
	   lib_module_list
	   module
	   generate
	   llambda))

;*---------------------------------------------------------------------*/
;*    *output*                                                         */
;*---------------------------------------------------------------------*/
(define *output*      (current-output-port))
(define *output-name* '())
(define *trace*       0)

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (parse-args! (cdr argv))
   (start-io!)
   (read-afile!)
   (mark-as-remember-module! *module-name*)
   (for-each (lambda (m)
		(mark-as-remember-module! m))
	     *lib-module-list*)
   (llambdas)
   (close-io!))

;*---------------------------------------------------------------------*/
;*    llambdas ...                                                     */
;*---------------------------------------------------------------------*/
(define (llambdas)
   (let loop ((exp (read *pin*)))
      (if (eof-object? exp)
	  (generate-module!)
	  (begin
	     (remember-exp! (llambda exp #t '()))
	     (loop (read *pin*))))))
   
