;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Llib/system.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jan 20 08:47:31 1993                          */
;*    Last change :  Mon Nov 14 14:38:05 1994 (serrano)                */
;*                                                                     */
;*    Le fichier ou sont rangees les fonctions systemes                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __system
   (foreign (obj    c-signal  (int bprocedure)       "c_signal")
	    (obj    c-get-signal-handler (int)       "get_signal_handler")
	    (define bool c-getenv? (string)          "getenv")
	    (string c-getenv  (string)               "getenv")
	    (int    c-system  (string)               "system")
	    (string c-date    ()                     "c_date")
	    (int    c-chdir   (string)               "chdir")
	    (define obj location           (obj)     "LOCATION")
	    (define obj c-location-ref     (obj)     "LOCATION_REF")
	    (define obj c-location-set!    (obj obj) "LOCATION_SET")
	    (obj    *the-command-line*               "command_line")
	    (define obj stack-ref          (obj)     "STACK_REFERENCE")
	    (define bool c-cnst?           (obj)     "CNSTP"))
   (export  (signal num thunk)
	    (get-signal-handler num)
	    (inline getenv string)
	    (inline system string)
	    (inline date)
	    (inline chdir string)
	    (inline location-ref  variable)
	    (inline location-set! variable value)
	    (command-line)
	    (inline cnst? <object>)
	    (check-for-version-soundness! module release level))
   (pragma  (location _no_side_effect_ _no_mutation_ _imbricable_)
	    (check-for-version-soundness! _no_eval_value_)))
 
;*---------------------------------------------------------------------*/
;*    check-for-version-soundness! ...                                 */
;*    -------------------------------------------------------------    */
;*    On teste la coherence d'un executable en s'assurrant que         */
;*    tous les modules ont ete compiles par le meme Bigloo.            */
;*---------------------------------------------------------------------*/
(define (check-for-version-soundness! module release level)
   (cond
      ((not (string? *release*))
       (set! *modules* (list module))
       (set! *release* release)
       (set! *level*   level))
      ((or (let ((min (-fx (min (string-length release)
				(string-length *release*))
			   1)))
	      (not (string=? (substring release 0 min)
			     (substring *release* 0 min))))
	   (and (char? level) (char? *level*) (not (char=? *level* level))))
       (define (release-name release level)
	  (if (char? level)
	      (let ((s " (level 0)"))
		 (string-set! s 8 level)
		 (string-append release level))
	      release))
       (error (string-append "Some modules have been compiled by: "
			     (release-name *release* (if (char? *level*)
							 (string *level*)
							 "")))
	      (string-append "and other by: "
			     (release-name release (if (char? level)
						       (string level)
						       "")))
	      (cons module *modules*)))
      (else
       (set! *modules* (cons module *modules*)))))

;*---------------------------------------------------------------------*/
;*    Des variables pour `check-for-version-soundness!'                */
;*---------------------------------------------------------------------*/
(define *release* #f)
(define *level*   #f)
(define *modules* '())
   
;*---------------------------------------------------------------------*/
;*    command-line ...                                                 */
;*---------------------------------------------------------------------*/
(define (command-line)
   *the-command-line*)

;*---------------------------------------------------------------------*/
;*    signal ...                                                       */
;*---------------------------------------------------------------------*/
(define (signal num proc)
   (cond
      ((not (=fx (procedure-arity proc) 1))
       (error "signal" "Wrong number of arguments" proc))
      ((or (<fx num 0) (>fx num 31))
       (error "signal" "Illegal signal" num))
      (else
       (c-signal num proc))))

;*---------------------------------------------------------------------*/
;*    get-signal-handler ...                                           */
;*---------------------------------------------------------------------*/
(define (get-signal-handler num)
   (c-get-signal-handler num))

;*---------------------------------------------------------------------*/
;*    getenv ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (getenv string)
   (if (c-getenv? string)
       (c-getenv string)
       #f))

;*---------------------------------------------------------------------*/
;*    system ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (system string)
   (c-system string))
   
;*---------------------------------------------------------------------*/
;*    date ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (date)
   (c-date))

;*---------------------------------------------------------------------*/
;*    chdir ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (chdir dirname)
   (c-chdir dirname))

;*---------------------------------------------------------------------*/
;*    location-ref ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (location-ref obj)
   (c-location-ref obj))

;*---------------------------------------------------------------------*/
;*    location-set! ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (location-set! obj val)
   (c-location-set! obj val))

;*---------------------------------------------------------------------*/
;*    cnst? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cnst? obj)
   (c-cnst? obj))
