;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Ieee/output.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:13:01 1992                          */
;*    Last change :  Mon Jan 16 13:52:22 1995 (serrano)                */
;*                                                                     */
;*    6.10.3 Output (page 31, r4)                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_output_6_10_3
   (foreign (define bool output-string-port (obj) "OUTPUT_STRING_PORTP")
            (define obj c-write-char   (bchar boutput-port) "WRITE_CHAR")
	    (obj c-write_char     (bchar boutput-port)      "write_char")
	    (obj c-write-object   (obj boutput-port)        "write_object")
	    (obj c-write-string   (bstring boutput-port)    "write_string")
	    (obj c-ill-char-rep   (bchar)                   "ill_char_rep"))
   (export  (set-write-length! len)
	    (get-write-length)
            (newline          . port)
	    (write            obj . port)
	    (display          obj . port)  
	    (write-char       obj . port)
	    (illegal-char-rep char) 
	    (display*         . obj)
	    (write*           . obj)
	    (print            . obj)
	    (fprint      port . obj)
	    (set-printer!     f)
	    (native-printer))
   (pragma  (display _dont_return_)
	    (display* _dont_return_)))

;*---------------------------------------------------------------------*/
;*    *max-length-write* ...                                           */
;*    -------------------------------------------------------------    */
;*    Cette variable contient le nombre maximum d'appels recursifs     */
;*    toleres lors d'un write.                                         */
;*---------------------------------------------------------------------*/
(define *max-length-write* -1)

;*---------------------------------------------------------------------*/
;*    *displayed*                                                      */
;*---------------------------------------------------------------------*/
(define *displayed* 0)

;*---------------------------------------------------------------------*/
;*    set-write-length ...                                             */
;*---------------------------------------------------------------------*/
(define (set-write-length! length)
   (set! *max-length-write* length))

;*---------------------------------------------------------------------*/
;*    get-write-length ...                                             */
;*---------------------------------------------------------------------*/
(define (get-write-length)
   *max-length-write*)

;*---------------------------------------------------------------------*/
;*    newline ...                                                      */
;*---------------------------------------------------------------------*/
(define (newline . port)
   (c-write-char #\Newline
		 (if (or (null? port)
			  (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    display ...                                                      */
;*---------------------------------------------------------------------*/
(define (display obj . port)
   (set! *displayed* 0)
   (if (or (eq? *current-printer* native-display)
	   (not (procedure? *current-printer*)))
       (write/display obj
		      (if (or (null? port)
			      (not (output-port? (car port))))
			  (current-output-port)
			  (car port))
		      'display)
       (try (apply *current-printer* (cons obj port))
	    (lambda (esc proc mes obj)
	       (set-printer! (native-printer))
	       (error proc mes obj)))))

;*---------------------------------------------------------------------*/
;*    native-display ...                                               */
;*---------------------------------------------------------------------*/
(define (native-display obj . port)
   (set! *displayed* 0)
   (if (or (eq? *current-printer* native-display)
	   (not (procedure? *current-printer*)))
       (write/display obj
		      (if (or (null? port)
			      (not (output-port? (car port))))
			  (current-output-port)
			  (car port))
		      'display)
       (try (apply *current-printer* (cons obj port))
	    (lambda (esc proc mes obj)
	       (set-printer! (native-printer))
	       (error proc mes obj)))))

;*---------------------------------------------------------------------*/
;*    write ...                                                        */
;*---------------------------------------------------------------------*/
(define (write obj . port)
   (set! *displayed* 0)
   (write/display obj
		  (if (or (null? port)
			  (not (output-port? (car port))))
		      (current-output-port)
		      (car port))
		  'write))

;*---------------------------------------------------------------------*/
;*    write-char ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-char char . port)
   (c-write-char char
		 (if (or (null? port)
			 (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    illegal-char-rep ...                                             */
;*---------------------------------------------------------------------*/
(define (illegal-char-rep char)
   (c-ill-char-rep char))

;*---------------------------------------------------------------------*/
;*    write/display ...                                                */
;*---------------------------------------------------------------------*/
(define (write/display obj port flag)
   (set! *displayed* (+fx 1 *displayed*))
   (cond
      ((and (>fx *max-length-write* 0)
	    (>=fx *displayed* *max-length-write*))
       (c-write-object "..." port))
      ((cell? obj)
       (write/display-cell obj port flag))
      ((struct? obj)
       (write/display-structure obj port flag))
      ((vector? obj)
       (write/display-vector obj port flag))
      ((pair? obj)
       (write/display-pair obj port flag))
      ((eq? flag 'write)
       (cond
	  ((string? obj)
	   (c-write-string (string-for-read obj) port))
	  ((char? obj) 
	   (c-write_char obj port))
	  (else
	   (c-write-object obj port))))
      (else
       (c-write-object obj port)))
   (unspecified))

;*---------------------------------------------------------------------*/
;*    write/display-cell ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-cell obj port flag)
   (c-write-string "#<cell:" port)
   (write/display (cell-ref obj) port flag)
   (c-write-char #\> port)
   obj)

;*---------------------------------------------------------------------*/
;*    write/display-structure ...                                      */
;*---------------------------------------------------------------------*/
(define (write/display-structure obj port flag)
   (c-write-char #\# port)
   (c-write-char #\{ port)
   (c-write-object (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       (c-write-char #\} port)
       (let ((len (-fx (struct-length obj) 1)))
	  (c-write-char #\space port)
	  (let loop ((i 0))
	     (cond
		((and (>fx *max-length-write* 0)
		      (>fx *displayed* *max-length-write*))
		 (c-write-object "... }" port))
		((=fx i len)
		 (write/display (struct-ref obj i) port flag)
		 (c-write-char #\} port))
		(else
		 (write/display (struct-ref obj i) port flag)
		 (c-write-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-vector ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-vector obj port flag)
   (c-write-char #\# port)
   (let ((tag (vector-tag obj)))
      (if (>fx tag 0)
	  (begin
	     (if (>=fx tag 100)
		 (c-write-object tag port)
		 (begin
		    (c-write-char #\0 port)
		    (if (>=fx tag 10)
			(c-write-object tag port)
			(begin
			   (c-write-char #\0 port)
			   (c-write-object tag port))))))))
   (c-write-char #\( port)
   (if (=fx 0 (vector-length obj))
       (c-write-char #\) port)
       (let ((len  (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (cond
		((and (>fx *max-length-write* 0)
		      (>=fx *displayed* *max-length-write*))
		 (c-write-object "... )" port))
		((=fx i len)
		 (write/display (vector-ref obj i) port flag)
		 (c-write-char #\) port))
		(else
		 (write/display (vector-ref obj i) port flag)
		 (c-write-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-pair ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-pair obj port flag)
   (c-write-char #\( port)
   (let loop ((l obj))
      (cond
	 ((null? (cdr l))
	  (write/display (car l) port flag)
	  (c-write-char #\) port))
	 ((and (>fx *max-length-write* 0)
	       (>=fx *displayed* *max-length-write*))
	  (c-write-object " . ... )" port))
	 ((not (pair? (cdr l)))
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (c-write-char #\. port)
	  (c-write-char #\space port)
	  (write/display (cdr l) port flag)
	  (c-write-char #\) port))
	 (else
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    Les fonctions qui suivent ne sont pas r4                         */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    print ...                                                        */
;*---------------------------------------------------------------------*/
(define (print . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l    obj)
		 (res '()))
	 (if (null? l)
	     (begin
		(c-write-char #\Newline port)
		res)
	     (let ((v (car l)))
		(write/display (car l) port 'display)
		(loop (cdr l) v))))))

;*---------------------------------------------------------------------*/
;*    display* ...                                                     */
;*---------------------------------------------------------------------*/
(define (display* . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     (unspecified)
	     (let ((v (car l)))
		(write/display (car l) port 'display)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    write* ...                                                       */
;*---------------------------------------------------------------------*/
(define (write* . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     (unspecified)
	     (let ((v (car l)))
		(write/display (car l) port 'write)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    fprint ...                                                       */
;*---------------------------------------------------------------------*/
(define (fprint port . obj)
   (set! *displayed* 0)
   (let loop ((l    obj)
	      (res '()))
      (if (null? l)
	  (begin
	     (c-write-char #\Newline port)
	     res)
	  (let ((v (car l)))
	     (write/display (car l) port 'display)
	     (loop (cdr l) v)))))

;*---------------------------------------------------------------------*/
;*    *current-printer* ...                                            */
;*    -------------------------------------------------------------    */
;*    On est oblige de faire l'affectation de `*current-printer*'      */
;*    en deux fois car sinon, a cause des optims, on n'aura pas        */
;*    eq? entre `native-printer' et `*current-printer*' !              */
;*---------------------------------------------------------------------*/
(define *current-printer* (unspecified))
(set! *current-printer* native-display)

;*---------------------------------------------------------------------*/
;*    set-printer! ...                                                 */
;*---------------------------------------------------------------------*/
(define (set-printer! f)
   (set! *current-printer* f))

;*---------------------------------------------------------------------*/
;*    native-printer ...                                               */
;*---------------------------------------------------------------------*/
(define (native-printer)
   native-display)




