;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.7/Eval/progn.scm ...        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 10:07:31 1994                          */
;*    Last change :  Thu Nov  3 10:08:27 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La normalisation des formes `begin'                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __progn
   (export (normalize-progn <expression>))
   (pragma (normalize-progn _no_eval_value_)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    Cette fonction doit etre utilisee pour normalise du code         */
;*    utilisateur tel qu'il est lu par le lecteur.                     */
;*---------------------------------------------------------------------*/
(define (normalize-progn body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      (else
       `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
				      (cdr body)
				      body)))
		    (if (null? body)
			'()
			(let ((expr (car body)))
			   (if (and (pair? expr) (eq? (car expr) 'begin))
			       (append (cdr expr) (loop (cdr body)))
			       (cons expr (loop (cdr body)))))))))))

