/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.7/Clib/eval.c ...           */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Sep 24 10:20:30 1993                          */
/*    Last change :  Mon Jul 11 10:35:39 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Quelques petites fonctions pour l'interprete (principalement     */
/*    des fonctions de debug et de trace)                              */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Des variables de controle                                        */
/*---------------------------------------------------------------------*/
static obj_t eval_name, wrong_number, not_a_proc;

/*---------------------------------------------------------------------*/
/*    Une recup ...                                                    */
/*---------------------------------------------------------------------*/
extern obj_t LENGTH___R4_PAIRS_AND_LISTS_6_3_229();

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    init_eval_cnst ...                                               */
/*---------------------------------------------------------------------*/
void
init_eval_cnst()
{
   eval_name    = c_string_to_string( "eval" );
   wrong_number = c_string_to_string( "wrong number of argument for" );
   not_a_proc   = c_string_to_string( "Not a procedure" );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_0 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_0( name, fun )
obj_t name, fun;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 0 ) )
         return PROCEDURE_ENTRY( fun )( fun, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_1 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_1( name, fun, a0 )
obj_t name, fun, a0;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 1 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}
       
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_2 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_2( name, fun, a0, a1 )
obj_t name, fun, a0, a1;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 2 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, a1, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}
       
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_3 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_3( name, fun, a0, a1, a2 )
obj_t name, fun, a0, a1, a2;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 3 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, a1, a2, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    funcall_4 ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
eval_funcall_4( name, fun, a0, a1, a2, a3 )
obj_t name, fun, a0, a1, a2, a3;
{
   if( PROCEDUREP( fun ) )
   {
      if( PROCEDURE_CORRECT_ARITYP( fun, 4 ) )
         return PROCEDURE_ENTRY( fun )( fun, a0, a1, a2, a3, BEOA );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    eval_apply ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
eval_apply( name, fun, list )
obj_t name, fun, list;
{
   if( PROCEDUREP( fun ) )
   {
      obj_t len = LENGTH___R4_PAIRS_AND_LISTS_6_3_229( list );
      
      if( PROCEDURE_CORRECT_ARITYP( fun, CINT( len ) ) )
         return apply( fun, list );
      else
         FAILURE( eval_name, wrong_number, name );
   }
   else
      FAILURE( eval_name, not_a_proc, name );
}
      





