;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Type/type.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 08:31:09 1993                          */
;*    Last change :  Mon Dec 19 09:48:54 1994 (serrano)                */
;*                                                                     */
;*    On retourne le type d'une expression                             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module type_type
   (include "Var/variable.sch"
	    "Foreign/type.sch")
   (import  tools_error
	    tools_shape
	    foreign_atomic)
   (export  (type-of exp)))

;*---------------------------------------------------------------------*/
;*    type-of ...                                                      */
;*---------------------------------------------------------------------*/
(define (type-of exp)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       (cond
	  ((global? atom)
	   (case (global-class atom)
	      ((function)
	       *bprocedure*)
	      ((foreign)
	       (case (foreign-class (global-value atom))
		  ((function)
		   (foreign-type (global-value atom)))
		  ((macro-function)
		   *void*)
		  (else
		   (foreign-type (global-value atom)))))
	      (else
	       *bobj*)))
	  ((local? atom)
	   (case (local-class atom)
	      ((function)
	       *bprocedure*)
	      ((return)
	       *breturn*)
	      (else
	       (local-type atom))))
	  ((integer? atom)
	   *long*)
	  ((real? atom)
	   *double*)
	  ((string? atom)
	   *string*)
	  ((char? atom)
	   *char*)
	  ((boolean? atom)
	   *bool*)
          ((eq? atom (unspecified))
           *bobj*)
	  (else
	   (error "type-of" "Unknown atom type of" (shape atom)))))
;*--- quote -----------------------------------------------------------*/
      ((quote ?exp)
       (cond
	  ((symbol? exp)
	   *bsymbol*)
	  ((pair? exp)
	   *bpair*)
	  ((vector? exp)
	   *bvector*)
	  (else
	   *bobj*)))
;*--- cast ------------------------------------------------------------*/
      ((cast ?type ?-)
       type)
;*--- assert ----------------------------------------------------------*/
      ((assert ?- ?- ?- ?body)
       (type-of body))
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       *bobj*)
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((body body))
	  (if (null? (cdr body))
	      (type-of (car body))
	      (loop (cdr body)))))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       *bobj*)
;*--- let, letrec & labels --------------------------------------------*/
      (((or let letrec labels) ?- ?body)
       (if (not (pair? body))
	   (type-of body)
	   (let loop ((body body))
	      (if (null? (cdr body))
		  (type-of (car body))
		  (loop (cdr body))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       *bcameleon*)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?-) ?body)
       (let loop ((body body))
	  (if (null? (cdr body))
	      (type-of (car body))
	      (loop (cdr body)))))
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       *bobj*)
;*--- if --------------------------------------------------------------*/
      (((or cif if) ?si ?alors ?sinon)
       (type-unification (type-of alors) (type-of sinon)))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (let loop ((type (type-of (cadr (car clauses))))
		  (clauses (cdr clauses)))
	  (cond
	     ((null? clauses)
	      type)
	     ((eq? type *bobj*)
	      type)
	     (else
	      (loop (type-unification (type-of (cadr (car clauses))) type)
		    (cdr clauses))))))
;*--- function --------------------------------------------------------*/
      ((function . ?-)
       *bprocedure*)
;*--- apply & funcall -------------------------------------------------*/
      (((or apply funcall) . ?-)
       *bobj*)
;*--- atom-application ------------------------------------------------*/
      (((atom ?function) . ?args)
       (cond
	  ((global? function)
	   (if (eq? (global-class function) 'foreign)
	       (if (not (eq? (type-type (foreign-type (global-value function)))
			     'function))
		   (partial-error ""
				  "Illegal foreign application"
				  (shape exp))
		   (car (type-exp (foreign-type (global-value function)))))
	       *bobj*))
	  ((local? function)
	   *bobj*)
	  (else
	   (partial-error "" "Illegal application" (shape exp)))))
;*--- application -----------------------------------------------------*/
      (else
       (let ((tcar (type-of (car exp))))
	  (if (not (eq? (type-type tcar) 'function))
	      *bobj*
	      (car (type-exp tcar)))))))
	  
;*---------------------------------------------------------------------*/
;*    type-unification ...                                             */
;*---------------------------------------------------------------------*/
(define (type-unification t1 t2)
   (cond
      ((eq? t1 t2)
       t1)
      ((eq? t1 *bcameleon*)
       t2)
      ((eq? t2 *bcameleon*)
       t1)
      (else
       *bobj*)))
       
	   
	   
