;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Tools/trace.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 15 15:04:42 1992                          */
;*    Last change :  Tue Dec 13 08:28:59 1994 (serrano)                */
;*                                                                     */
;*    La gestion des traces                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_trace
   (export (start-trace      what mode)
	   stop-trace
	   *trace-port* 
	   (add-trace-mask   mask)
	   (satisfy?         mask)
	   (trace-mask-value m)
	   (mask             . values)
	   (when-trace       mask . t)))

;*---------------------------------------------------------------------*/
;*    L'initialisation des variables locales                           */
;*---------------------------------------------------------------------*/
(define *trace-port* #f)
(define *trace-mask* 0)
(define *trace-mode* 'or)

;*---------------------------------------------------------------------*/
;*    start-trace ...                                                  */
;*---------------------------------------------------------------------*/
(define (start-trace what mode)
   (set! *trace-mode* mode)
   (set! *trace-port* (open-output-file "trace"))
   (if (not (output-port? *trace-port*))
       (error "start-trace" "Can't open trace file" "trace"))
   (if (eq? what 'all)
       (set! *trace-mask* (+ 131072 65535))
       (set! *trace-mask* 0)))
       
;*---------------------------------------------------------------------*/
;*    stop-trace ...                                                   */
;*---------------------------------------------------------------------*/
(define (stop-trace)
   (if (output-port? *trace-port*)
       (close-output-port *trace-port*)))

;*---------------------------------------------------------------------*/
;*    add-trace-mask ...                                               */
;*---------------------------------------------------------------------*/
(define (add-trace-mask m)
   (set! *trace-mask* (bit-or *trace-mask* (trace-mask-value m))))

;*---------------------------------------------------------------------*/
;*    trace-one-mask-value ...                                         */
;*---------------------------------------------------------------------*/
(define (trace-one-mask-value m)
   (case m
      ((read)
       1)
      ((init)
       2)
      ((env)
       4)
      ((eps)
       8)
      ((inline)
       16)
      ((hoist)
       32)
      ((type)
       64)
      ((remove)
       128)
      ((parse)
       256)
      ((lift)
       512)
      ((loop)
       1024)
      ((cnst)
       2048)
      ((cgen)
       4096)
      ((other)
       8192)
      ((beta)
       16384)
      ((effect)
       32768)
      ((0cfa)
       65536)
      ((assert)
       131072)
      ((integ)
       262144)
      ((stack)
       524288)
      (else
       (error "add-trace-mask" "unknown mask" m))))

;*---------------------------------------------------------------------*/
;*    trace-mask-value ...                                             */
;*---------------------------------------------------------------------*/
(define (trace-mask-value m)
   (if (not (pair? m))
       (trace-one-mask-value m)
       (let loop ((m   m)
		  (acc 0))
	  (if (null? m)
	      acc
	      (loop (cdr m)
		    (bit-or (trace-one-mask-value (car m)) acc))))))
			  
;*---------------------------------------------------------------------*/
;*    satisfy? ...                                                     */
;*---------------------------------------------------------------------*/
(define (satisfy? mask)
   (if (= *trace-mask* 0)
       #f
       (if (eq? *trace-mode* 'or)
	   (if (= (bit-and *trace-mask* mask) 0)
	       #f
	       #t)
	   (if (= *trace-mask* mask)
	       #t
	       #f))))
	    
;*---------------------------------------------------------------------*/
;*    when-trace ...                                                   */
;*---------------------------------------------------------------------*/
(define (when-trace mask . thunks)
   (if (satisfy? (trace-mask-value mask))
       (begin
	  (for-each (lambda (v) (v)) thunks)
	  (flush-output-port *trace-port*))))
		 
;*---------------------------------------------------------------------*/
;*    mask                                                             */
;*---------------------------------------------------------------------*/
(define (mask . values)
   (let loop ((values values))
      (if (null? values)
	  0
	  (bit-or (trace-mask-value (car values)) (loop (cdr values))))))
	      
	      
       
       
	 
