;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Tailrec/walk.scm ...     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 30 10:44:02 1994                          */
;*    Last change :  Thu Dec  8 09:31:03 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On fait une passe de tailrecursivation tres simple.              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tailrec_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tailrec_exp)
   (export  (tailrec-walk schemes)))

;*---------------------------------------------------------------------*/
;*    tailrec-walk ...                                                 */
;*    -------------------------------------------------------------    */
;*    On est oblige de faire deux parcours du code. Le premier pour    */
;*    regler le cas des definitions globales, le second pour changer   */
;*    les defintions des fonctions.                                    */
;*---------------------------------------------------------------------*/
(define (tailrec-walk tree)
   (verbose "   . Tailrec" #\Newline)
   (let loop ((walk tree))
      (if (null? walk)
	  tree
	  (let* ((fun     (car walk))
		 (value   (global-value fun))
		 (body    (function-body value))
		 (formals (function-args value)))
	     (function-body-set!
	      value
	      (tailrec-definition fun formals (tailrec-expression body)))
	     (loop (cdr walk))))))
