;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Heap/restore.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 23 17:04:32 1992                          */
;*    Last change :  Wed Jun  8 10:11:16 1994 (serrano)                */
;*                                                                     */
;*    On recharge un tas qui a ete construit par bigloo                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module heap_restore
   (include "Var/variable.sch")
   (import  engine_param
	    tools_speek
	    heap_compact
	    heap_abstract
	    var_env
	    tools_hash)
   (export  (restore-heap)))

;*---------------------------------------------------------------------*/
;*    restore-heap ...                                                 */
;*---------------------------------------------------------------------*/
(define (restore-heap)
   (verbose "   . Heap" #\Newline)
   (for-each restore-one-heap *heap-names*)
   (abstract-init!)
   ;; on a fini de restorer la librairie. On 
   ;; supprime eventuellement la fonction call/cc.
   (if (and (not *call/cc?*)
	    (not *lib-mode*))
       (let ((callcc (find-in-global-environment 'call/cc *Genv*)))
	  (if (and (global? callcc)
		   (eq? (global-module callcc) '__R4_CONTROL_FEATURES_6_9))
	      (unbind-in-global-environment! 'call/cc *Genv*)))))

;*---------------------------------------------------------------------*/
;*    restore-one-heap ...                                             */
;*---------------------------------------------------------------------*/
(define (restore-one-heap heap-name)
   (if (compacted-heap? heap-name)
       (restore-one-compacted-heap heap-name)
       (restore-one-uncompacted-heap heap-name)))

;*---------------------------------------------------------------------*/
;*    restore-one-compacted-heap ...                                   */
;*---------------------------------------------------------------------*/
(define (restore-one-compacted-heap heap-name)
   (let ((port (open-input-binary-file heap-name)))
      (if (not (binary-port? port))
	  (error "restore-heap" "Can't open heap file" heap-name)
	  (let ((len   (input-obj port)))
	     (if (not (=fx len (hash-table-length *Genv* 'genv)))
		 (error "restore-one-comtacted-heap"
			"Corrupted heap file"
			heap-name)
		 (let loop ((i 0))
		    (if (=fx i len)
			'done
			(begin
			   (let ((new-bucket (input-obj port)))
			      (if (not (null? new-bucket))
				  (let loop ((new new-bucket))
				     (cond
					((null? new)
					 (hash-table-set-bucket!
					  *Genv*
					  'genv
					  (lambda (old)
					     (if (null? old)
						 new-bucket
						 (append! new-bucket old)))
					  i))
					(else
					 (let* ((pr    (car new))
						(value (global-value pr)))
					    (cond
					       ((eq? (global-import pr)
						     'foreign)
						(foreign-type-set!
						 value
						 (uncompact-type
						  (foreign-type value))))
					       ((function? value)
						(function-type-res-set!
						 value
						 (uncompact-type
						  (function-type-res
						   value))))))
					 (loop (cdr new)))))))
			   (loop (+fx i 1))))))))))

;*---------------------------------------------------------------------*/
;*    restore-one-uncompacted-heap ...                                 */
;*---------------------------------------------------------------------*/
(define (restore-one-uncompacted-heap heap-name)
   (if (string? heap-name)
       (let* ((port    (open-input-file heap-name))
	      (handler (lambda (escape proc mes obj)
			  (notify-error proc mes obj)
			  (input-port-display-error port (current-error-port))
			  (close-input-port port)
			  (exit -5))))
	  (if (not (input-port? port))
	      (error "restore-heap"
		     "Can't open heap file"
		     heap-name)
	      (try (let loop ((r (read port)))
		      (if (eof-object? r)
			  (close-input-port port)
			  (let ((name (vector-ref r 1)))
			     (uncompact! r)
			     (loop (read port)))))
		   handler)))))

