;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../tools.scm ...                                                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct 19 09:15:38 1993                          */
;*    Last change :  Thu Jan 20 09:22:35 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les utilitaires pour manipuler les `ftype'                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foreign_tools
   (include "Foreign/type.sch")
   (import  tools_hash
	    tools_error
	    tools_shape
	    tools_args
            heap_abstract
	    foreign_atomic
	    foreign_parse
	    foreign_declare)
   (export  (define-type id name type exp)
	    (define-subtype parent id name type exp)
	    (get-type id)
	    (make/get-function-type! of from)
	    (type-exists? id)
	    (bigloo-type? type)
	    (foreign-type? type)
	    (init-foreign-interface!)
	    (for-each-type! fun!)
	    (find-casting to casting*)))

;*---------------------------------------------------------------------*/
;*    define-type ...                                                  */
;*---------------------------------------------------------------------*/
(define (define-type id name type exp)
   (if (type-exists? id)
       (partial-error "define-type" "`foreign type' redefinition" id)
       (let ((new (bind-type! id)))
	  (type-name-set!  new name)
	  (type-type-set!  new type)
	  (type-exp-set!   new exp)
	  new)))

;*---------------------------------------------------------------------*/
;*    define-subtype ...                                               */
;*---------------------------------------------------------------------*/
(define (define-subtype parents id name type exp)
   (if (type-exists? id)
       (partial-error "define-type" "`foreign type' redefinition" id)
       (let ((new (define-type id name type exp)))
	  (type-parents-set! new parents)
	  (for-each (lambda (parent)
		       (type-sons-set! parent (cons new (type-sons parent))))
		    parents)
	  new)))

;*---------------------------------------------------------------------*/
;*    type-exists? ...                                                 */
;*---------------------------------------------------------------------*/
(define (type-exists? id)
   (type? (find-type id)))

;*---------------------------------------------------------------------*/
;*    foreign-type-env                                                 */
;*---------------------------------------------------------------------*/
(define *fte* '())

;*---------------------------------------------------------------------*/
;*    init-foreign-interface! ...                                      */
;*---------------------------------------------------------------------*/
(define (init-foreign-interface!)
   (let ((env (make-hash-table 'FTenv
                               'symbol
                               type-create
                               type-id
                               type-pp)))
      (if (not (hashtable? env 'FTenv))
          (error "init-foreign-interface" "Can't build FTenv" env)
	  (begin
	     (set! *fte* env)
	     (define-atomic-type!)))))

;*---------------------------------------------------------------------*/
;*    type-create ...                                                  */
;*---------------------------------------------------------------------*/
(define (type-create id)
   (let ((new (make-type)))
      (type-id-set! new id)
      new))

;*---------------------------------------------------------------------*/
;*    type-pp ...                                                      */
;*---------------------------------------------------------------------*/
(define (type-pp port type)
   (fprint port (type-id type)))

;*---------------------------------------------------------------------*/
;*    find-type ...                                                    */
;*---------------------------------------------------------------------*/
(define (find-type id)
   (find-object id *fte* 'FTenv))

;*---------------------------------------------------------------------*/
;*    bind-type! ...                                                   */
;*---------------------------------------------------------------------*/
(define (bind-type! id)
   (bind-object! id *fte* 'FTenv))
      
;*---------------------------------------------------------------------*/
;*    get-type ...                                                     */
;*    -------------------------------------------------------------    */
;*    Si cette fonction ne trouve pas son type. On arrette en          */
;*    emetant une erreur.                                              */
;*---------------------------------------------------------------------*/
(define (get-type id)
   (let ((type (find-type id)))
      (cond
	 ((not (type? type))
	  (error "get-type" "cant find `foreign type'" id))
	 ((eq? (type-type type) 'alias)
	  (if (type? (type-exp type))
	      (type-exp type)
	      (begin
		 (type-exp-set! type (get-type (type-exp type)))
		 (type-exp type))))
	 (else
	  type))))

;*---------------------------------------------------------------------*/
;*    for-each-type! ...                                               */
;*---------------------------------------------------------------------*/
(define (for-each-type! fun!)
   (define (walk-on-bucket! bucket)
      (if (null? bucket)
	  'done
	  (begin
	     (fun! (car bucket))
	     (walk-on-bucket! (cdr bucket)))))
   (walk-on-hash-table! walk-on-bucket! *fte* 'FTenv))

;*---------------------------------------------------------------------*/
;*    bigloo-type? ...                                                 */
;*---------------------------------------------------------------------*/
(define (bigloo-type? type)
   (or (eq? (type-type type) 'bigloo-type)
       (eq? (type-type type) 'bigloo-atom)))

;*---------------------------------------------------------------------*/
;*    foreign-type? ...                                                */
;*---------------------------------------------------------------------*/
(define (foreign-type? type)
   (not (bigloo-type? type)))

;*---------------------------------------------------------------------*/
;*    make/get-function-type! ...                                      */
;*---------------------------------------------------------------------*/
;*    -------------------------------------------------------------    */
;*    Pour eviter d'avoir a parcourir systematiquement l'env qui       */
;*    contient tous les types, je construit le type d'une fonction     */
;*    a partir du type de ses arguments                                */
;*---------------------------------------------------------------------*/
(define (make/get-function-type! to from)
   (let* ((name (symbol-append  (let loop ((from from)
					   (res  ':))
				   (cond
				      ((null? from)
				       res)
				      ((not (pair? from))
				       (symbol-append (type-id from)
						      '-
						      res))
				      (else
				       (loop (cdr from)
					     (symbol-append (type-id
							     (car from))
							    res)))))
				'->
				(type-id to)))
	  (type (find-type name)))
      (if (type? type)
	  type
	  (declare-function/types name to from))))

;*---------------------------------------------------------------------*/
;*    find-casting ...                                                 */
;*---------------------------------------------------------------------*/
(define (find-casting to casting*)
   (cond
      ((null? casting*)
       #f)
      ((eq? (casting-to (car casting*)) to)
       (car casting*))
      (else
       (find-casting to (cdr casting*)))))
