/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.6/Include/bigloo.h ...      */
/*  wiz  -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep  1 17:15:00 1993                          */
/*    Last change :  Mon Jun  6 08:28:54 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Les choses de `Bigloo'                                           */
/*=====================================================================*/
#ifndef BIGLOO_H
#define BIGLOO_H

#ifndef GC_PRIVATE_H
#  include <gc_private.h>
#endif
#undef abs

#if defined( NULL )
#   undef NULL
#endif

/*---------------------------------------------------------------------*/
/*    Les includes indispensables                                      */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <setjmp.h>
#include <errno.h>
#if( defined( sun ) && defined( sparc ) )
#   include <stdlib.h>
#endif
#include <math.h>
#if defined( sony_news )
#   include <news/machparam.h>
#endif
#include <limits.h>

/*---------------------------------------------------------------------*/
/*    Les sites ou sont ranges les libraries et les includes           */
/*---------------------------------------------------------------------*/
#define LIBRARY_DIR() "/home/cornas/icsla/serrano/prgm/project/bigloo/lib/1.6"
#define INCLUDE_DIR() "/home/cornas/icsla/serrano/prgm/project/bigloo/lib/1.6"
#define CC() "gcc"
/*---------------------------------------------------------------------*/
/*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
/*    Attention, le trois macros ci-dessus doivent imperativement etre */
/*    ligne 40 et 42 (pour la distribution)                            */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Le type booleen (je ne veux plus fixer que c'est unsigned char)  */
/*---------------------------------------------------------------------*/
#define bool_t int

/*---------------------------------------------------------------------*/
/*    Quelques macros system dependant                                 */
/*---------------------------------------------------------------------*/
#define DOWN 55
#define UP   66

/*--- Les casts pour `longjmp'/`setjmp' -------------------------------*/
#define JMP_BUF void
#define JMP_VAL int


#if defined( SPARC ) || defined( sparc )
#   include <sys/signal.h>
#   define STACK_GROWS DOWN
#   define PTR_ALIGNMENT 2
    /* Le nombre de fenetre de registre sur sparc */
#   define BIG_ENDIAN
#   if defined( __svr4__ )
#      include <sys/regset.h>
#      define SETJMP setjmp
#      define LONGJMP longjmp
#   else
#      define SETJMP _setjmp
#      define LONGJMP _longjmp
#   endif
#   define NB_WINDOW_REGISTER SPARC_MAXREGWINDOW
#else
#   if( defined( PYR ) || defined( pyr ) \
        || (defined( sony_news ) && defined( r3000 )) )
#      define STACK_GROWS DOWN
#      define PTR_ALIGNMENT 2
#      define BIG_ENDIAN
#      define SETJMP _setjmp
#      define LONGJMP _longjmp
#   else
#      if( defined( i386 ) )
#         define STACK_GROWS DOWN
#         define PTR_ALIGNMENT 2
#         define LITTLE_ENDIAN
#         undef SIGBUS
#         define SIGBUS SIGUSR1
#         define SETJMP _setjmp
#         define LONGJMP _longjmp
#      else
#         if( defined( __pa_risc ) || defined(_PA_RISC1_0) || defined(_PA_RISC1_1) )
#            define STACK_GROWS UP
#            define PTR_ALIGNMENT 2
#            define BIG_ENDIAN
#            define SIGBUS _SIGBUS
#            define SETJMP _setjmp
#            define LONGJMP _longjmp
#         else
#            if( defined( sun ) && defined( mc68000 ) )
#               define STACK_GROWS DOWN
#               define PTR_ALIGNMENT 2
#               define BIG_ENDIAN
#               define SETJMP _setjmp
#               define LONGJMP _longjmp
#            else
                /* thank's to Drew Whitehouse [Drew.Whitehouse@anu.edu.au] */
#               if( defined( sgi) || defined( ultrix ) && defined( mips ) )
#                  define STACK_GROWS DOWN
#                  define PTR_ALIGNMENT 2
#                  if defined( ultrix ) && defined( mips )
#                     define LITTLE_ENDIAN
#                  else
#                     define BIG_ENDIAN
#                  endif
#                  define SETJMP _setjmp
#                  define LONGJMP _longjmp
#               else
#                  if( defined( _IBMR2 ) )
#                     define STACK_GROWS DOWN
#                     define PTR_ALIGNMENT 2
#                     define SETJMP setjmp
#                     define LONGJMP longjmp
#                  else
#                     if( defined( NeXT ) && defined( mc68000 ) )
#                        define STACK_GROWS DOWN
#                        define PTR_ALIGNMENT 2
#                        define BIG_ENDIAN
#                        define SETJMP setjmp
#                        define LONGJMP longjmp
#                     else
                         --> error "I need to know the way the c-stack grows, see `public/grows.c'"
#                     endif
#                  endif
#               endif                   
#            endif
#         endif
#      endif
#   endif
#endif

#if( !defined( NB_WINDOW_REGISTER ) )
#   define NB_WINDOW_REGISTER 0
#endif

/*---------------------------------------------------------------------*/
/*    Quelques messages d'erreur personnel.                            */
/*---------------------------------------------------------------------*/
#define EHEAP       500  /* Pas assez de memoire pour allouer le tas   */
#define EMEMORY     501  /* Plus assez de place dans le tas            */
#define ETARGS      502  /* on passe trop d'args a apply               */

/*---------------------------------------------------------------------*/
/*    Les macros du GC ...                                             */
/*---------------------------------------------------------------------*/
#define NO_GC            1
#define BOEHM_1_X_GC     2
#define BOEHM_2_X_GC     3
#define BOEHM_3_X_GC     4

#define GC BOEHM_2_X_GC

/*---------------------------------------------------------------------*/
/*    Il y a plusieurs formes d'objets:                                */
/*    Les objets allouees:                                             */
/*            +--------+--------+--------+--------+                    */
/*            |....signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 30 bits:                                    */
/*            +--------+--------+--------+--------+                    */
/*            |....signed fixed point value.....??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 6 bits:                                     */
/*            +--------+--------+--------+--------+                    */
/*            |..........................|xxxxxx??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*    Les objets immediats 8 bits:                                     */
/*            +--------+--------+--------+--------+                    */
/*            |.................|xxxxxxxx|......??|                    */
/*            +--------+--------+--------+--------+                    */
/*                                                                     */
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
/*    Ou sont les `tags' et quel `mask' cela represente.               */
/*---------------------------------------------------------------------*/
#define TAG_SHIFT     PTR_ALIGNMENT
#define TAG_MASK      (~(((~0L) >> PTR_ALIGNMENT << PTR_ALIGNMENT)))

/*---------------------------------------------------------------------*/
/*    Les `tags' des pointeurs ...                                     */
/*---------------------------------------------------------------------*/
#if( (GC == BOEHM_1_X_GC) )
#   define TAG_INT          1  /*  Les integer sont tagues  ....01     */
#   define TAG_CNST         3  /*  Les cnsts sont taguees   ....11     */
#   define TAG_STRUCT       0  /*  Les pointer sont tagues  ....00     */
#else
#   if( (GC == BOEHM_2_X_GC) || (GC == BOEHM_3_X_GC) )
#      define TAG_INT       1  /*  Les integer sont tagues  ....01     */
#      define TAG_CNST      2  /*  Les cnsts sont taguees   ....10     */
#      define TAG_STRUCT    0  /*  Les pointer sont tagues  ....00     */
#      define TAG_PAIR      3  /*  Les pairs sont taguees   ....11     */
#   else
#      if( GC == NO_GC )
#         define TAG_INT    0  /*  Les integer sont tagues  ....00     */
#         define TAG_CNST   2  /*  Les cnsts sont taguees   ....10     */
#         define TAG_STRUCT 1  /*  Les pointer sont tagues  ....01     */
#         define TAG_PAIR   3  /*  Les pairs sont taguees   ....11     */
#      else
          --> error "Unknown garbage collector type"
#      endif
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    La taille de la table hashage                                    */
/*---------------------------------------------------------------------*/
#define HASH_TABLE_SIZE() 1024

/*---------------------------------------------------------------------*/
/*    Les `header' des structures ...                                  */
/*---------------------------------------------------------------------*/
#define HEADER_PAIR                  ((header_t)BINT( 0 ))
#define HEADER_STRING                ((header_t)BINT( 1 ))
#define HEADER_VECTOR                ((header_t)BINT( 2 ))
#define HEADER_PROCEDURE             ((header_t)BINT( 3 ))
#define HEADER_TRUE                  ((header_t)BINT( 4 ))
#define HEADER_FALSE                 ((header_t)BINT( 5 ))
#define HEADER_UNSPEC                ((header_t)BINT( 6 ))
#define HEADER_NIL                   ((header_t)BINT( 7 ))
#define HEADER_SYMBOL                ((header_t)BINT( 8 ))
#define HEADER_STACK                 ((header_t)BINT( 9 ))
#define HEADER_INPUT_PORT            ((header_t)BINT( 10 ))
#define HEADER_OUTPUT_PORT           ((header_t)BINT( 11 ))
#define HEADER_RGRAMMAR              ((header_t)BINT( 12 ))
#define HEADER_CELL                  ((header_t)BINT( 13 ))
#define HEADER_EOF                   ((header_t)BINT( 14 ))
#define HEADER_STRUCT                ((header_t)BINT( 15 ))
#define HEADER_REAL                  ((header_t)BINT( 16 ))
#define HEADER_EOA                   ((header_t)BINT( 17 ))
#define HEADER_FOREIGN               ((header_t)BINT( 18 ))
#define HEADER_OUTPUT_STRING_PORT    ((header_t)BINT( 19 ))

/*---------------------------------------------------------------------*/
/*    Les differents objects `Sqic' :                                  */
/*---------------------------------------------------------------------*/
typedef long  int_t;
typedef int_t header_t;

typedef union object {
   int_t              integer;   /*  Les entiers                       */
   
   header_t           header;    /*  Un champs un peu fictif mais      */
                                 /*  il est utile pour pouvoir acceder */
                                 /*  au header des objets sans savoir  */
                                 /*  quel est leur type. Tous les      */
                                 /*  headers sont en tete des struct   */
                                 /*  on peut donc le header global     */
                                 /*  plutot que les header locaux      */
   
   struct {                      /*  Les pairs.                        */
#if( !(defined( TAG_PAIR ) ) )            
      header_t        header;    /*  Le header est facultatif, il      */
#endif      
      union object   *car;       /*  depend du GC qu'on utilise.       */
      union object   *cdr;       /*  Dans tous les cas, il y a biensur */
   } pair_t;                     /*  un `car' et un `cdr' :-)          */

#if( defined( ALLOCATE_CONSTANT ) )
   struct {                      /*  Les booleens qui sont au nombre   */
      header_t        header;    /*  de 2: true et false               */
   } boolean_t;
#endif

   struct {                      /*  Les chaines de char, juste une    */
      header_t        header;    /*  longueur, la chaine C suit.       */
      union object   *length;
   } string_t;

   struct {                      /*  Les vecteurs, un header et une    */
      header_t        header;    /*  taille (ATTENTION: sur 22 bits,   */
      union object   *length;    /*  voir la macro vector-length).     */
   } vector_t;

   struct {                      /*  Les fermetures                    */
      header_t        header;    
      union object *(*entry)();
      union object *(*va_entry)();
      long            arity;       
      char           *env;       /*  Ce champs est utilise pour etre   */
   } procedure_t;                /*  sur que l'alignement est correct. */

   struct {                      /*  Les fermetures legeres            */
      union object *(*entry)();
      char           *env;
   } procedure_light_t;
   
   struct {                      /*  Les fermetures extra-legeres:     */
      char           *env;
   } procedure_extra_light_t;
   
   struct {                      /*  Les symboles, un nom et une       */
      header_t        header;    /*  valeur                            */
      char           *name;
      union object   *cval;
   } symbol_t;

   struct {                      /* Les output_port                    */
      header_t        header;    /* grosso-modo cette structure        */
      FILE           *file;      /* comporte juste un file et son nom  */
      char           *name;
   } output_port_t;

	struct {                      /*  Les output_string_port            */
		header_t        header;    /* Cette structure comporte:          */
      char           *buffer;    /* - un buffer                        */
		long            size;      /* - une taille                       */
      long            offset;    /* - un offset                        */
   } output_string_port_t;
	
   struct {                      /*  Les input_port                    */
      header_t        header;    /*  un input_port est:                */
      union object   *class;     /*    - une classe                    */
      char           *name;      /*    - une chaine                    */
      FILE           *file;      /*    - un file                       */
      union object   *bufsiz;    /*    - une taille                    */
      union object   *eof;       /*    - un flag                       */
      union object   *backward;  /*    - un backward                   */
      union object   *forward;   /*    - un forward                    */
      union object   *remember;  /*    - un souvenir                   */
      union object   *mark;      /*    - un marqueur                   */
		char           *annexe;    /*    - une annexe (cf grands tokens) */
		union object   *anxsiz;    /*    - la taille de l'annexe         */
      char           *buffer;    /*    - un buffer                     */
   } input_port_t;

   struct {                      /*  Les cellules. Ces objets sont     */
      header_t        header;    /*  utilisees quand il y a des var    */
      union object   *obj;       /*  capturees qui sont en plus ecrite */
   } cell_t;

   struct {                      /*  Les structures,                   */
      header_t        header;    /*  sont constituees de :             */
      union object   *key;       /*                      - une cle     */
      union object   *length;    /*                      - une long.   */
      union object   *slot;      /*                      - des slots   */
   } struct_t;

   struct {                      /*  Les nombres flottants             */
      header_t        header;
      double          real;
   } real_t;

   struct {                      /*  Les piles de `call/cc'            */
      header_t        header;    /*  sont:                             */
      union object   *self;      /*        - un ptr sur soit meme      */
      union object   *size;      /*        - une taille                */
      char           *stack;     /*        - un espace memoire         */
   } stack_t;

   struct {                      /*  Les types etrangers               */
      header_t        header;    
      union object   *id;
      void           *value;
   } foreign_t;
} *obj_t;

typedef obj_t (*function_t)();

/*---------------------------------------------------------------------*/
/*    Les procedures d'allocations                                     */
/*---------------------------------------------------------------------*/
#if( GC == DELACOUR_GC )
#   define ALLOCATE( size )
#   define ALLOCATE_ATOMIC( size )
#   define INLINE_ALLOCATE( size )
#   define INLINE_ALLOCATE_ATOMIC( size )
#   define INIT_ALLOCATION() 1
#   define FREE_ALLOCATION() 1
#else
#   if( GC == BOEHM_1_X_GC )
       extern obj_t gc_malloc();
       extern obj_t gc_malloc_atomic();
#      define ALLOCATE( size ) gc_malloc( size )
#      define ALLOCATE_ATOMIC( size ) gc_malloc_atomic( size )
#      define INLINE_ALLOCATE( size ) gc_malloc( size )
#      define INLINE_ALLOCATE_ATOMIC( size ) gc_malloc_atomic( size )
#      define INLINE_ALLOCATE( size ) gc_malloc( size )
#      define INIT_ALLOCATION( size ) (gc_init() , expand_hp( size ))
#      define FREE_ALLOCATION();
#   else
#      if( (GC == BOEHM_2_X_GC) || (GC == BOEHM_3_X_GC) )
#         if( !defined( GC_PRIVATE_H ) )
             extern obj_t GC_malloc();
             extern obj_t GC_malloc_atomic();
#         endif
#         define ALLOCATE( size ) (obj_t)(GC_malloc( size ))
#         define ALLOCATE_ATOMIC( size ) GC_malloc_atomic( size )
#         define INLINE_ALLOCATE( size ) (obj_t)(GC_malloc( size ))
#         define INLINE_ALLOCATE_ATOMIC( size ) GC_malloc_atomic( size )
#         if( (TAG_STRUCT != 0) && (TAG_PAIR != 0) )
#            define INIT_ALLOCATION( size )                   \
                ( GC_init(),                                  \
                  GC_expand_hp( size ),                       \
                  GC_register_displacement( TAG_STRUCT ),     \
                  GC_register_displacement( TAG_PAIR ),       \
                  1 )
#         else
#            if( TAG_STRUCT != 0 ) 
#               define INIT_ALLOCATION( size )                \
                   ( GC_init(),                               \
                     GC_expand_hp( size ),                    \
                     GC_register_displacement( TAG_STRUCT ),  \
                     1 )
#            else
#               if( TAG_PAIR != 0 )
#                  define INIT_ALLOCATION( size )            \
                      ( GC_init(),                           \
                        GC_expand_hp( size ),                \
                        GC_register_displacement( TAG_PAIR ),\
                        1 )
#               else
                   define INIT_ALLOCATION( size )          \
                      ( GC_init(), GC_expand_hp( size ) )
#               endif
#            endif
#         endif
#         define FREE_ALLOCATION();
#      else
#         if( GC == NO_GC )
             extern obj_t heap_alloc();
#            define ALLOCATE( size ) heap_alloc( size )
#            define ALLOCATE_ATOMIC( size ) ALLOCATE( size )
#            define INLINE_ALLOCATE( size ) ALLOCATE( size )
#            define INLINE_ALLOCATE_ATOMIC( size ) ALLOCATE( size )
#            define INIT_ALLOCATION( size ) init_heap( size )
#            define FREE_ALLOCATION() free_heap()
#         else
             --> error "Unknown garbage collector type"
#         endif                
#     endif          
#   endif
#endif

/*---------------------------------------------------------------------*/
/*    Les macros qui servent a taguer/detaguer                         */
/*---------------------------------------------------------------------*/
#define TAG( val, shift, tag )   ((long)(((long)(val) << shift) | tag))
#define UNTAG( val, shift, tag ) ((long)((long)(val) >> shift))

/*---------------------------------------------------------------------*/
/*    Les macros de conversions utilisees par `Sqic'                   */
/*    -------------------------------------------------------------    */
/*    Attention, il est normal que pour faire la conversion `bigloo->c'*/
/*    j'utilise une soustraction et non pas un `and'. En faisant comme */
/*    ca, le compilateur C peut bien optimiser les access aux          */
/*    differents champs.                                               */
/*---------------------------------------------------------------------*/
#define BINT( i )          (obj_t)TAG( i, TAG_SHIFT, TAG_INT )
#define CINT( i )          (long)UNTAG( i, TAG_SHIFT, TAG_INT )

#define BREF( r )          ((obj_t)((long)r | TAG_STRUCT))
#define CREF( r )          ((obj_t)((long)r - TAG_STRUCT))

#define BLIGHT( l )        BPAIR( l )
#define CLIGHT( l )        CPAIR( l )

#if( defined( TAG_PAIR ) )
#   define BPAIR( p )      ((obj_t)((long)p | TAG_PAIR))
#   define CPAIR( p )      ((obj_t)((long)p - TAG_PAIR))
#else
#   define BPAIR( p )      BREF( p )
#   define CPAIR( p )      CREF( p )
#endif

#define BFUN( f )          ((obj_t)(f))
#define CFUN( f )          ((obj_t (*)())(f))

#define BCNST( c )         (obj_t)TAG( c, TAG_SHIFT, TAG_CNST )
#define CCNST( c )         (long)UNTAG( c, TAG_SHIFT, TAG_CNST )

#define BCONT( c )         ((obj_t)(c))
#define CCONT( c )         (c)

#define TRUEP( c )         ((bool_t)(c != BFALSE))

#define BCHAR( i )         ((obj_t)((long)BCHARH + \
												((long)((bool_t)(i) << 8))))
#define CCHAR( i )         (long)((long)(i)>>8)

#define CTRUE              ((bool_t)1)
#define CFALSE             ((bool_t)0)

#define FAILURE( p, m, o ) the_failure( p, m, o )

#define FUNCTION_ADDRESS( f ) (function_t)(&(f))

/*---------------------------------------------------------------------*/
/*    Le `CASTING'                                                     */
/*---------------------------------------------------------------------*/
#define CBOOL_TO_BBOOL( o ) (o ? BTRUE : BFALSE )
#define BBOOL_TO_CBOOL( o ) (o != BFALSE)

#define CSTRING_TO_BSTRING( s ) c_string_to_string( s )
#define BSTRING_TO_CSTRING( s ) ((char *)CREF( s ) + STRING_SIZE)

#define CHAR_TO_INT( c ) BINT( (unsigned char)(CCHAR( c )) )
#define INT_TO_CHAR( i ) BCHAR( CINT( i ) )

#define DOUBLE_TO_REAL( d ) (make_real( d ))
#define REAL_TO_DOUBLE( r ) (REAL( r ).real)

#define CVOID_TO_BVOID( e ) (e, BUNSPEC)
#define BVOID_TO_CVOID( e ) ((void)e) 

/*---------------------------------------------------------------------*/
/*    Les `constantes' peuvent etre soit allouees soit constante.      */
/*---------------------------------------------------------------------*/
#if defined( ALLOCATE_CONSTANT )
#   define BNIL          nil_object
#   define BFALSE        false_object
#   define BTRUE         true_object
#   define BUNSPEC       unspec_object
#   define BEOF          end_of_file_object
#   define BEOA          end_of_argument_object
    extern obj_t nil_object, unspec_object, end_of_file_object;
    extern obj_t true_object, false_object;
#else
#   define BNIL          ((obj_t)BCNST( 0 ))
#   define BFALSE        ((obj_t)BCNST( 1 ))
#   define BTRUE         ((obj_t)BCNST( 2 ))
#   define BUNSPEC       ((obj_t)BCNST( 3 ))
#   define BEOF          ((obj_t)BCNST( 4 ))
#   define BCHARH        ((obj_t)BCNST( 5 ))
#   define BEOA          ((obj_t)BCNST( 6 ))
#endif

/*---------------------------------------------------------------------*/
/*    Les macros GENERALES                                             */
/*    -------------------------------------------------------------    */
/*    Les macros concernant tous les objects. On trouve ici les        */
/*    macros qui ne sont pas propre a une categorie d'object en        */
/*    particulier.                                                     */
/*---------------------------------------------------------------------*/
#define OBJ_SIZE               ((long)(sizeof( ((obj_t)0) ) ))
#define HEADER( o )            (CREF( o )->header)

#if( TAG_STRUCT != 0 )
#   define POINTERP( o )       ((((long)o) & TAG_MASK) == TAG_STRUCT)
#else
#   define POINTERP( o )       (o && ((((long)o) & TAG_MASK) == TAG_STRUCT))
#endif

#if( TAG_CNST != 0 )
#   define CNSTP( o )          ((((long)o) & TAG_MASK) == TAG_CNST)
#else
#   define CNSTP( o )          (o && ((((long)o) & TAG_MASK) == TAG_CNST))
#endif

#if( TAG_SHIFT <= LONG_MAX )
#   define BOUND_CHECK( o, v ) ((unsigned long)o < (unsigned long)v)
#else
#   define BOUND_CHECK( o, v ) (((long)o >= 0) && ((long)o < (long)v))
#endif

/*---------------------------------------------------------------------*/
/*    Les deux macros les plus dangeureuses de la terre. A n'          */
/*    utilisez que si on sait vraiment ce qu'on fait.                  */
/*---------------------------------------------------------------------*/
#define PEEK( v, i ) (*((obj_t *)(((long)CREF( v )) + (OBJ_SIZE * CINT( i )))))
#define POKE( var, i, val ) (PEEK( var, i ) = val, var)

/*---------------------------------------------------------------------*/
/*    Il existe plusieurs procedures d'allocation. Les `atomic'        */
/*    concernent les allocations qui ne contiennent pas de pointer.    */
/*---------------------------------------------------------------------*/
#define MAKE_OBJECT( size, head, an_object )                            \
   (an_object = ALLOCATE( size ),                                       \
    an_object->header = head, an_object)

#define MAKE_INLINE_OBJECT( size, head, an_object )                     \
   (an_object = INLINE_ALLOCATE( size ),                                \
    an_object->header = head, an_object)

#define MAKE_ATOMIC_OBJECT( size, head, an_object )                     \
   (an_object = ALLOCATE_ATOMIC( size ),                                \
    an_object->header = head, an_object)

#define EQP( o1, o2 ) ((long)o1 == (long)o2)

#define BOOLEANP( o ) (((long)o == (long)BTRUE) || ((long)o == (long)BFALSE))

#define NOT( o ) (!o)   

/*---------------------------------------------------------------------*/
/*    La manipulation des SYMBOLS (brrr !)                             */
/*---------------------------------------------------------------------*/
#define SYMBOLP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_SYMBOL))

#define SYMBOL( o )  (CREF( o )->symbol_t)
   
#define GET_HASH_NUMBER( s ) (obj_t)(get_hash_number( SYMBOL( s ).name ))

#define SYMBOL_SIZE (sizeof( ((obj_t)0)->symbol_t ))

#define SYMBOL_TO_STRING( o ) c_string_to_string( SYMBOL( o ).name )

#define GET_SYMBOL_PLIST( o ) (SYMBOL( o ).cval)

#define SET_SYMBOL_PLIST( o, v ) (GET_SYMBOL_PLIST( o ) = v)

/*---------------------------------------------------------------------*/
/*    le trippotage des PAIRs                                          */
/*---------------------------------------------------------------------*/
#define PAIR_SIZE (sizeof( ((obj_t)0)->pair_t ))

#define PAIR( o ) (CPAIR( o )->pair_t)

#if( GC == BOEHM_2_X_GC )
#define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
    extern obj_t make_pair();
#   define MAKE_PAIR( a, d ) make_pair( a, d )
#   define MAKE_O3_PAIR( op, opp, a, d )                                     \
   ( opp = (obj_t)(&(GC_objfreelist[ NUMBER_OF_CONS_WORDS ])),               \
     (( !FASTLOCK_SUCCEEDED() || (op = *((obj_t *)opp)) == 0 ) ?             \
     (op=(obj_t)GC_generic_malloc_words_small(NUMBER_OF_CONS_WORDS,NORMAL )):\
      (*((obj_t *)opp) = (obj_t)(obj_link( (obj_t)op )),                     \
       (obj_t)(GC_words_allocd += NUMBER_OF_CONS_WORDS))),                   \
     (((obj_t)op)->pair_t).car = a,                                          \
     (((obj_t)op)->pair_t).cdr = d,                                          \
    BPAIR( ( obj_t )op ) )
#else
#   if( GC == BOEHM_3_X_GC )
#   define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
       extern obj_t make_pair();
#      define MAKE_PAIR( a, d ) make_pair( a, d )
#      define MAKE_O3_PAIR( op, opp, a, d )                                  \
      ( opp = ((obj_t)&(GC_objfreelist[ NUMBER_OF_CONS_WORDS ])),            \
        (( !FASTLOCK_SUCCEEDED() || (op = *((obj_t *)opp)) == 0 ) ?          \
        (op=(obj_t)GC_generic_malloc_words_small(NUMBER_OF_CONS_WORDS,       \
																 NORMAL )):                  \
         (*((obj_t *)opp) = (obj_t)(obj_link( (obj_t)op )),                  \
			 obj_link(op) = 0,                                                  \
          (obj_t)(GC_words_allocd += NUMBER_OF_CONS_WORDS))),                \
        (((obj_t)op)->pair_t).car = a,                                       \
        (((obj_t)op)->pair_t).cdr = d,                                       \
       BPAIR( ( obj_t )op ) )
#   else
#      define MAKE_PAIR( a, d )                                              \
         (a_pair = MAKE_INLINE_OBJECT( PAIR_SIZE, HEADER_PAIR, an_object ),  \
          a_pair->pair_t.car = a,                                            \
          a_pair->pair_t.cdr = d,                                            \
          BPAIR( a_pair ) )
#      define MAKE_O3_PAIR( op, opp, a, d ) MAKE_PAIR( a, d )      
#   endif
#endif

#if( !(defined( TAG_PAIR ) ) )
#   define PAIRP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_PAIR))
#else
#   define PAIRP( c ) ((c && ((((long)c)&TAG_MASK) == TAG_PAIR)))
#endif

#define NULLP( c ) ((long)(c) == (long)BNIL)

#define CAR( c )   (PAIR( c ).car)
#define CDR( c )   (PAIR( c ).cdr)

#define SET_CAR( c, v ) ((CAR( c ) = v), c)
#define SET_CDR( c, v ) ((CDR( c ) = v), c)

/*---------------------------------------------------------------------*/
/*    Les CHARs                                                        */
/*---------------------------------------------------------------------*/
#define CHARP( o ) (((long)(o) & (long)(BCHARH)) == (long)BCHARH)

/* Soit pour des FILE soit pour des STRING */
#define WRITE_CHAR( o, p )         \
   ( OUTPUT_STRING_PORTP( p ) ?    \
	    strputc( CCHAR( o ), p ) :  \
       ((obj_t)(fputc( CCHAR( o ), OUTPUT_PORT( p ).file )), o) )

/* la meme mais juste pour les FILE C */
#define WRITE_CHAR_F( o, p )       \
   ( (obj_t)(fputc( CCHAR( o ), OUTPUT_PORT( p ).file )), o )

#define CHAR_LT( o1, o2 ) ((long)o1 < (long)o2)
   
#define CHAR_GT( o1, o2 ) ((long)o1 > (long)o2)
   
#define CHAR_LE( o1, o2 ) ((long)o1 <= (long)o2)
   
#define CHAR_GE( o1, o2 ) ((long)o1 >= (long)o2)
   
#define CHAR_UPCASE( o )   BCHAR( toupper( CCHAR( o ) ) )
#define CHAR_DOWNCASE( o ) BCHAR( tolower( CCHAR( o ) ) )
  
/*---------------------------------------------------------------------*/
/*      Les STRINGs de caracteres                                      */
/*---------------------------------------------------------------------*/
#define STRINGP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_STRING))

#define STRING( o )  (CREF( o )->string_t)

#define STRING_SIZE (sizeof( ((obj_t)0)->string_t))

#define STRING_LENGTH( s )  STRING( s ).length

#define STRING_REF( v, i ) BSTRING_TO_CSTRING( v )[ CINT( i ) ]
 
#define STRING_SET( s, i, c ) \
   ((STRING_REF( s, i ) = CCHAR( c )), s )

#define STRING_COPY( s )  \
   (c_string_to_string((char *)(CREF( s ) + STRING_SIZE)))
    
/*---------------------------------------------------------------------*/
/*    Les macros concernant les VECTORs                                */
/*---------------------------------------------------------------------*/
#define VECTOR_SIZE (sizeof( ((obj_t)0)->vector_t))
#define VECTOR_LENGTH_SHIFT 24
#define VECTOR_LENGTH_MASK (~(unsigned long)(0xff << VECTOR_LENGTH_SHIFT))

#define VECTOR( o ) CREF( o )->vector_t

#define VECTORP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_VECTOR))

#if( (PTR_ALIGNMENT == TAG_SHIFT) )
#   define VECTOR_REF( v, i ) \
       (*((obj_t *)((long)CREF( v ) + (VECTOR_SIZE - TAG_INT) + ((long)i))))
#else       
#   define VECTOR_REF( v, i ) \
       (*((obj_t *)(((long)CREF( v )) + VECTOR_SIZE + (OBJ_SIZE * CINT( i )))))
#endif       
    
#define VECTOR_SET( v, i, o ) ((VECTOR_REF( v, i ) = o), v)

/*---------------------------------------------------------------------*/
/*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
/*    -------------------------------------------------------------    */
/*    Pour pouvoir coder une information supplementaire sur les        */
/*    vecteurs, je limite leur taille a 2^22. Cela signifie que        */
/*    l'info peut-etre codee sur les 8 bits de poids fort.             */
/*---------------------------------------------------------------------*/
#define VECTOR_LENGTH( v ) \
   ((obj_t)((unsigned long)(VECTOR( v ).length) & VECTOR_LENGTH_MASK))

#define VECTOR_TAG_SET( v, tag )               \
    ( VECTOR( v ).length =                     \
	   (obj_t)((long)VECTOR_LENGTH( v ) |        \
				 (((long)CINT( tag )) << VECTOR_LENGTH_SHIFT)) )

#define VECTOR_TAG( v )                                       \
      BINT( ((obj_t)(((unsigned long)(VECTOR( v ).length) &  \
				~VECTOR_LENGTH_MASK) >> VECTOR_LENGTH_SHIFT)) )

/*---------------------------------------------------------------------*/
/*    L'ARITHMETIQUE qui comme elle se doit est divisee en deux        */
/*    parties, l'ARITHMETIQUE ENTIERE et l'ARITHMETIQUE FLOTANTE. En   */
/*    plus il y a quelques macros valables pour les deux arithmetiques.*/
/*---------------------------------------------------------------------*/
/*--- l'ARITHMETIQUE ENTIERE ------------------------------------------*/
#define INTEGERP( o ) ((((long)o) & TAG_MASK) == TAG_INT)

#if( !TAG_INT )
#   define ADD_I( a, b ) ((obj_t)((long)( a ) + (long)( b ))) 
#   define SUB_I( a, b ) ((obj_t)((long)( a ) - (long)( b ))) 
#   define MUL_I( a, b ) ((obj_t)((CINT( a ) * (long)b)))
#   define DIV_I( a, b ) (obj_t)(BINT( CINT( a )/CINT( b ) ))
#   define ADD_I_PTAG( a, b ) (ADD_I( a, b ))
#   define SUB_I_PTAG( a, b ) (SUB_I( a, b ))
#   define PSUB_TAG( a ) BINT( a )
#   define PADD_TAG( a ) BINT( a )
#else
#   define ADD_I( a, b ) ((obj_t)(((long)( a ) & ~TAG_INT) + (long)( b )))
#   define SUB_I( a, b ) ((obj_t)(((long)( a ) - (long)( b )) | TAG_INT))
#   define MUL_I( a, b ) (BINT( (CINT( a )    * CINT( b )) ))
#   define DIV_I( a, b ) (BINT( (CINT( a )    / CINT( b )) ))
#   define ADD_I_PTAG( a, b ) ((obj_t)((long)(a) + (long)(b)))
#   define SUB_I_PTAG( a, b ) ((obj_t)((long)(a) - (long)(b)))
#   define PADD_TAG( a ) ((obj_t)((long)BINT( a ) + (long)TAG_INT))
#   define PSUB_TAG( a ) ((obj_t)((long)BINT( a ) - (long)TAG_INT))
#endif

#define EQ_I( x, y ) (((long)x) == ((long)y))
#define LT_I( x, y ) (((long)x) <  ((long)y))
#define LE_I( x, y ) (((long)x) <= ((long)y))
#define GT_I( x, y ) (((long)x) >  ((long)y))
#define GE_I( x, y ) (((long)x) >= ((long)y))

#define NEG_I( x ) (BINT( -CINT( x )))
#define ABS_I( x ) (LT_I( x, BINT(  0 )) ? BINT( -CINT( x ) ) : x)

#define BITOR( x, y )   (obj_t)(((long)x) | ((long)y))
#define BITAND( x, y )  (obj_t)(((long)x) & ((long)y))
#define BITXOR( x, y )  BINT( CINT( x ) ^ CINT( y ) )
#define BITNOT( x )     BINT( ~CINT(x) )
#define BITLSH( x, y )  BINT( CINT(x) << CINT(y) )
#define BITRSH( x, y )  BINT( CINT(x) >> CINT(y) )
#define BITURSH( x, y ) BINT((unsigned long)CINT(x) >> (unsigned long)CINT(y))

#define REMAINDER_I( a, b ) (BINT( (CINT( a ) % CINT( b )) ))
#define QUOTIENT_I( x, y ) DIV_I( x, y )

#define ODDP_I( x )  (CINT( x ) & 0x1)
#define EVENP_I( x ) (!ODDP_I( x ))

/*--- l'ARITHMETIQUE FLOTANTE -----------------------------------------*/
#define REAL_SIZE (sizeof( ((obj_t)0)->real_t ))

#define REALP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_REAL))

#define REAL( o ) CREF( o )->real_t

#define ADD_R( a, b ) (make_real( REAL( a ).real + REAL( b ).real))
#define SUB_R( a, b ) (make_real( REAL( a ).real - REAL( b ).real))
#define MUL_R( a, b ) (make_real( REAL( a ).real * REAL( b ).real))
#define DIV_R( a, b ) (make_real( REAL( a ).real / REAL( b ).real))
#define NEG_R( a )    (make_real( -REAL( a ).real ))
    
#define EQ_R( x, y ) ((REAL( x ).real) == (REAL( y ).real))
#define LT_R( x, y ) ((REAL( x ).real) < (REAL( y ).real))
#define LE_R( x, y ) ((REAL( x ).real) <= (REAL( y ).real))
#define GT_R( x, y ) ((REAL( x ).real) > (REAL( y ).real))
#define GE_R( x, y ) ((REAL( x ).real) >= (REAL( y ).real))

#define ZEROP_R( x )  ((REAL( x ).real) == (double)(0.0))
#define POSITIVEP_R(x) ((REAL( x ).real) > (double)(0.0))
#define NEGATIVEP_R(x) ((REAL( x ).real) < (double)(0.0))
    
#define ABS_R( x ) (REAL( x ).real < 0 ? make_real( -REAL( x ).real ) : x)
                                          
/*--- Les fonctions de converstions arithmetiques ---------------------*/
#define INT_TO_REAL(x) (make_real( (double)(CINT( x )) ))
#define REAL_TO_INT(x) (BINT( (long)(REAL( x ).real) ))
    
/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDUREs                                   */
/*---------------------------------------------------------------------*/
#define PROCEDURE_SIZE (sizeof( ((obj_t)0)->procedure_t))

#define PROCEDURE( o ) CREF( o )->procedure_t

#define PROCEDURE_ENTRY( fun ) (obj_t)(PROCEDURE( fun ).entry)
#define PROCEDURE_VA_ENTRY( fun ) (obj_t)(PROCEDURE( fun ).va_entry)

#define PROCEDUREP( fun ) \
   (POINTERP( fun ) && (HEADER( fun ) == HEADER_PROCEDURE))

#define PROCEDURE_ARITY( fun ) (PROCEDURE( fun ).arity)

#define VA_PROCEDUREP( fun ) ( PROCEDURE_ARITY( fun ) < 0 )
   
#define PROCEDURE_CORRECT_ARITYP( fun, num )      \
   ( (PROCEDURE_ARITY( fun ) == num) ||           \
     (VA_PROCEDUREP( fun ) &&                     \
       ((-num - 1) <= (PROCEDURE_ARITY( fun )))) )

#define PROCEDURE_ENV_REF( p, i ) \
   (*((obj_t *)(((long)&(PROCEDURE( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_ENV_SET( p, i, o ) ((PROCEDURE_ENV_REF( p, i ) = o), p)

/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDURE_LIGHTs                             */
/*---------------------------------------------------------------------*/
#define PROCEDURE_LIGHT_SIZE \
   (sizeof( ((obj_t)0)->procedure_light_t ))

#define PROCEDURE_LIGHTP( o ) PAIRP( o )
      
#define PROCEDURE_LIGHT( o ) CLIGHT( o )->procedure_light_t

#define PROCEDURE_LIGHT_ENTRY( fun ) (obj_t)(PROCEDURE_LIGHT( fun ).entry)
   
#define PROCEDURE_LIGHT_ENV_REF( p, i ) \
   (*((obj_t *)(((long)&(PROCEDURE_LIGHT( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_LIGHT_ENV_SET( p, i, o ) \
   ((PROCEDURE_LIGHT_ENV_REF( p, i ) = o), p)

/*---------------------------------------------------------------------*/
/*    La manipulation des PROCEDURE_EXTRA_LIGHTs                       */
/*---------------------------------------------------------------------*/
#define PROCEDURE_EXTRA_LIGHT_SIZE \
   (sizeof( ((obj_t)0)->procedure_extra_light_t ))

#define PROCEDURE_EXTRA_LIGHT( o ) (o->procedure_extra_light_t)

#define PROCEDURE_EXTRA_LIGHT_ENTRY( fun ) \
   (obj_t)(PROCEDURE_EXTRA_LIGHT( fun ).entry)
   
#define PROCEDURE_EXTRA_LIGHT_ENV_REF( p, i ) \
   (*((obj_t *)(((long)&(PROCEDURE_EXTRA_LIGHT( p ).env)) + (OBJ_SIZE * i))))
   
#define PROCEDURE_EXTRA_LIGHT_ENV_SET( p, i, o ) \
   ((PROCEDURE_EXTRA_LIGHT_ENV_REF( p, i ) = o), p)

/*---------------------------------------------------------------------*/
/*      Les CELLules                                                   */
/*---------------------------------------------------------------------*/
#define CELL_SIZE (sizeof( ((obj_t)0)->cell_t))

#define CELL( o ) CREF( o )->cell_t

#define CELLP( o ) \
   ( POINTERP( o ) && (HEADER( o ) == HEADER_CELL) )

#define MAKE_CELL( v )                                      \
   ( MAKE_OBJECT( CELL_SIZE, HEADER_CELL, a_cell ),         \
     a_cell->cell_t.obj = (obj_t)(v),                       \
     BREF( a_cell ) )

#define CELL_SET( c, v ) ((CELL( c ).obj = v), c)
   
#define CELL_REF( c )    (CELL( c ).obj)

/*---------------------------------------------------------------------*/
/*    Les macros d'access aux OUTPUT_PORTs                             */
/*---------------------------------------------------------------------*/
#define OUTPUT_PORT_SIZE (sizeof( ((obj_t)0)->output_port_t ))

#define OUTPUT_PORT( o ) CREF( o )->output_port_t

#define OUTPUT_PORTP( o ) \
   ( POINTERP( o ) && ( (HEADER( o ) == HEADER_OUTPUT_PORT) || \
							   (HEADER( o ) == HEADER_OUTPUT_STRING_PORT) ) )

#define FLUSH_OUTPUT_PORT( o )  \
   ( OUTPUT_STRING_PORTP( o ) ? \
	  strport_flush( o ) :       \
	  ((fflush( OUTPUT_PORT( o ).file )), o) )

#define BOUTPUT_PORT_TO_CFILE( o )                                         \
   ( OUTPUT_STRING_PORTP( o ) ?                                            \
	  FAILURE( c_string_to_string( "output-port-to-file" ),                 \
				  c_string_to_string( "argument can't be a string port"),      \
				  o )                                                          \
	  : OUTPUT_PORT( o ).file )

#define CFILE_TO_BOUTPUT_PORT( f ) (make_output_port( "<c-port>", f))

/*---------------------------------------------------------------------*/
/*    Les output_string_port                                           */
/*---------------------------------------------------------------------*/
#define OUTPUT_STRING_PORT_SIZE (sizeof( ((obj_t)0)->output_string_port_t ))

#define OUTPUT_STRING_PORT( o ) CREF( o )->output_string_port_t

#define OUTPUT_STRING_PORTP( o ) \
   ( HEADER( o ) == HEADER_OUTPUT_STRING_PORT )

#define OUTPUT_STRING_PORT_BUFFER_SIZE 1024

#define END_OF_STRING_PORTP( o ) \
   ( OUTPUT_STRING_PORT( o ).offset == OUTPUT_STRING_PORT( o ).size )

/*---------------------------------------------------------------------*/
/*    Les macros d'access aux INPUT_PORTs                              */
/*---------------------------------------------------------------------*/
#define CLASS_FILE    BINT( 0 )
#define CLASS_CONSOLE BINT( 1 )
#define CLASS_STRING  BINT( 2 )
   
#define INPUT_PORT_SIZE (sizeof( ((obj_t)0)->input_port_t ))

#define INPUT_PORT( o ) CREF( o )->input_port_t

#define INPUT_PORTP( o ) \
    (POINTERP( o ) && (HEADER( o ) == HEADER_INPUT_PORT))

#define BUFFER( p ) ((unsigned char *)&(INPUT_PORT( p ).buffer))

#define EOF_OBJECTP( o ) ( o == BEOF )
    
/*--- Les macros de lecture -------------------------------------------*/
#define INPUT_PORT_READ_CHAR( p )                                           \
   (  INPUT_PORT( p ).forward = ADD_I_PTAG( INPUT_PORT( p ).forward,        \
                                          PSUB_TAG( 1 ) ),                  \
     (long)((long)BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) - 1 ] ) )

#define READ_CHAR( p )                                                      \
   ( INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     INPUT_PORT( p ).forward = ADD_I_PTAG( INPUT_PORT( p ).forward,         \
                                           PSUB_TAG( 1 ) ),                 \
     INPUT_PORT_REMEMBER_REF( p ),                                          \
     BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward )-1 ] ?               \
     BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward )-1 ] ) :      \
        !input_port_fill_buffer( p )?                                       \
           INPUT_PORT( p ).forward =                                        \
             SUB_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),          \
           reset_eof( p ),                                                  \
           BEOF :                                                           \
           ( INPUT_PORT( p ).forward =                                      \
               ADD_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),        \
             BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).backward ) ] ) ) )
   
#define PEEK_CHAR( p )                                                      \
   ( INPUT_PORT( p ).backward = INPUT_PORT( p ).forward,                    \
     BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] ?                 \
      BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward )] ) :        \
        (!input_port_fill_buffer( p )) ?                                    \
           BEOF :                                                           \
           (INPUT_PORT( p ).forward =                                       \
              ADD_I_PTAG( INPUT_PORT( p ).forward, PSUB_TAG( 1 ) ),         \
           BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] ) ))

#define INPUT_PORT_THROW_CHAR( p, n )                                       \
   INPUT_PORT( p ).backward = ADD_I( INPUT_PORT( p ).backward, n )

#define INPUT_PORT_REMEMBER_REF( p )                                        \
   INPUT_PORT( p ).remember = INPUT_PORT( p ).forward
   
#define INPUT_PORT_REMEMBER_BACK_REF( p )                                   \
   INPUT_PORT( p ).remember = SUB_I_PTAG( INPUT_PORT( p ).forward,          \
                                          PSUB_TAG( 1 ) )
      
#define INPUT_PORT_EOFP( p )                                                \
   ( (INPUT_PORT( p ).eof &&                                                \
      (BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] == '\0')) ?     \
     BTRUE : BFALSE )

#define INPUT_PORT_EOLP( p )                                                \
   ( (BUFFER( p )[ (long)CINT( INPUT_PORT( p ).forward ) ] == '\n') ?       \
      BTRUE : BFALSE )
      
#define INPUT_PORT_BOLP( p )                                                \
   ( (!INPUT_PORT( p ).backward ||                                          \
      (BUFFER( p )[ (long)CINT( INPUT_PORT( p ).backward ) - 1 ] == '\n')) ?\
      BTRUE : BFALSE )
   
#define INPUT_PORT_GET_LENGTH( p )                                          \
   ( INPUT_PORT( p ).annexe ? ADD_I( INPUT_PORT( p ).anxsiz,                \
                                     SUB_I( INPUT_PORT( p ).backward,       \
			  								           INPUT_PORT( p ).mark) )         \
                            : SUB_I( INPUT_PORT( p ).backward,              \
											    INPUT_PORT( p ).mark) )  

#define INPUT_PORT_STOLE_CHAR( p )                                          \
   ( INPUT_PORT( p ).backward = ADD_I_PTAG( INPUT_PORT( p ).backward,       \
                                            PSUB_TAG( 1 ) ),                \
     INPUT_PORT( p ).forward = INPUT_PORT( p ).remember =                   \
     INPUT_PORT( p ).backward,                                              \
      BUFFER( p )[ (long)CINT( INPUT_PORT( p ).remember ) - 1 ] ?           \
        BCHAR( BUFFER( p )[ (long)CINT( INPUT_PORT( p ).remember )-1 ] ) :  \
        BEOF )
   
#define INPUT_PORT_AJUST_CURSOR( p )                                        \
   ( INPUT_PORT( p ).forward  = INPUT_PORT( p ).remember,                   \
     INPUT_PORT( p ).mark     = INPUT_PORT( p ).backward,                   \
     INPUT_PORT( p ).backward = INPUT_PORT( p ).forward )                   \

#define INPUT_PORT_TOKEN_TOO_LARGEP( p ) (INPUT_PORT( p ).annexe != 0L)

/*---------------------------------------------------------------------*/
/*    Les STRUCtures                                                   */
/*---------------------------------------------------------------------*/
#define STRUCT_SIZE (sizeof( ((obj_t)0)->struct_t))

#define STRUCT( o ) CREF( o )->struct_t

#define STRUCTP( c ) (POINTERP( c ) && (HEADER( c ) == HEADER_STRUCT))

#define STRUCT_KEY( c ) STRUCT( c ).key

#define STRUCT_LENGTH( c ) STRUCT( c ).length
   
#define STRUCT_SLOT_REF( c, i )                                        \
   (*((obj_t *)(((long)&(STRUCT( c ).slot)) + (OBJ_SIZE * CINT( i ) ))))

#define STRUCT_SLOT_SET( c, i, o ) ((STRUCT_SLOT_REF( c, i ) = o), c)

/*---------------------------------------------------------------------*/
/*    Les `STACK' (cf. call/cc)                                        */
/*---------------------------------------------------------------------*/
#define STACK_SIZE  (sizeof( ((obj_t)0)->stack_t))
   
#define STACK( _o_ ) CREF( _o_ )->stack_t

#define STACKP( _s_ ) (POINTERP( _s_ ) && (HEADER( _s_ ) == HEADER_STACK))

#define MAKE_STACK( _size_, aux ) \
   (BREF( MAKE_OBJECT( STACK_SIZE + (long)_size_, HEADER_STACK, aux )))
   
/*---------------------------------------------------------------------*/
/*    Les `LOCATION's                                                  */
/*---------------------------------------------------------------------*/
#define LOCATION( x )        BREF( &x )
#define LOCATION_REF( x )    (*((obj_t *)CREF( x )))
#define LOCATION_SET( x, y ) ((LOCATION_REF( x ) = (obj_t)y ), y)

/*---------------------------------------------------------------------*/
/*    Les `ENV'                                                        */
/*---------------------------------------------------------------------*/
#define ENV_REF( env, offset ) (((obj_t *)env)[ offset ])
#define ENV_SET( env, offset, value ) (ENV_REF( env, offset ) = value, value)
   
/*---------------------------------------------------------------------*/
/*    Les macros, structures et externes de debug bigloo.              */
/*    -------------------------------------------------------------    */
/*    Le champ `link' et la variable `link' sont tous les deux         */
/*    INDISPENSABLES. La variable sert pour les retours multiples, le  */
/*    champs sert pour l'affichage de la pile (voir debug.c).          */
/*---------------------------------------------------------------------*/
struct dframe {
   obj_t          symbol;
   struct dframe *link;  
};

#define PUSH_LAMBDA_TRACE( name )                  \
   struct dframe  frame;                           \
   struct dframe *link;                            \
                                                   \
   frame.symbol = name;                            \
   frame.link   = top_of_frame;                    \
   link         = top_of_frame;                    \
   top_of_frame = &frame;            
   
#define POP_LAMBDA_TRACE( res )  \
   ( top_of_frame = link, res )

#define GET_LAMBDA_STACK() BREF( top_of_frame )
#define SET_LAMBDA_STACK( t ) \
   ( top_of_frame = (struct dframe *)CREF( t ), BUNSPEC )

extern struct dframe *top_of_frame;

/*---------------------------------------------------------------------*/
/*    Les macros utilisee pour les `foreign_t'                         */
/*---------------------------------------------------------------------*/
#define FOREIGNP( o ) (POINTERP( o ) && (HEADER( o ) == HEADER_FOREIGN))
#define FOREIGN( o )  CREF( o)->foreign_t
#define FOREIGN_SIZE  (sizeof( ((obj_t)0)->foreign_t))

#define FOREIGN_ID( o )    FOREIGN( o ).id
#define FOREIGN_VALUE( o ) FOREIGN( o ).value

#define FOREIGN_ISP( o, key ) (FOREIGNP( o ) && (EQP( FOREIGN_ID( o ), key)))
#define BFOREIGN_TO_CFOREIGN( o ) (FOREIGN_VALUE( o ))

#define FOREIGN_EQP( o1, o2 ) (FOREIGN_VALUE( o1 ) == FOREIGN_VALUE( o2 ))
#define FOREIGN_NULLP( o1 ) (!FOREIGN_VALUE( o1 ))

#define FOREIGN_STRUCT_REF( o, tname, slot ) \
   (((tname)(FOREIGN_VALUE( o )))->slot)
#define FOREIGN_STRUCT_SET( o, tname, slot, value ) \
   (FOREIGN_STRUCT_REF( o, tname, slot ) = value, BUNSPEC)

#define FOREIGN_ARRAY_REF( tname, array, offset ) \
   (((tname)array)[ offset ])

#define FOREIGN_ARRAY_SET( tname, array, offset, value ) \
   (FOREIGN_ARRAY_REF( tname, array, offset ) = value, BUNSPEC)
   
/*---------------------------------------------------------------------*/
/*    Les definitions de certains objets alloues                       */
/*---------------------------------------------------------------------*/
#define DEFINE_STRING( name, str, len )                    \
   static struct { header_t header;                        \
                   obj_t    length;                        \
                   char     string[len+(4-(len % 4))]; }   \
      name = { HEADER_STRING, BINT( len ), str }           \

/*---------------------------------------------------------------------*/
/*    Les marks pour l'externement lineaire                            */
/*---------------------------------------------------------------------*/
#define TAG_MARK (unsigned long)((unsigned long)1 << ((8 * OBJ_SIZE) - 1))

#define IS_MARKP( x )                                     \
   ( CNSTP( (unsigned long)x ) && (TAG_MARK & (unsigned long) x) )

#define BINT_TO_MARK( x )                                 \
   (obj_t)( (unsigned long)( (unsigned long)BCNST( CINT( x ) ) | TAG_MARK ) )

#define MARK_TO_BINT( x )                                 \
   (obj_t)( BINT((unsigned long)CCNST( (unsigned long)x & (~TAG_MARK) ) ) )

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t an_object, a_pair;
extern obj_t a_procedure, a_cell;
extern obj_t __ContinueValue;
extern obj_t c_constant_string_to_string();
extern bool_t input_port_fill_buffer();

extern obj_t c_string_to_string();
extern obj_t c_string_to_symbol();

extern obj_t apply();
extern obj_t eval_apply();

extern double strtod();
extern obj_t make_real();

extern obj_t strputc();
extern obj_t strputs();
extern obj_t strport_flush();

#endif
