;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Ieee/input.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 15:42:25 1992                          */
;*    Last change :  Tue Nov 30 12:10:08 1993 (serrano)                */
;*                                                                     */
;*    6.10.2 Input (page 30, r4)                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_input_6_10_2
   (foreign (define bchar  c-read-char   (binput-port) "READ_CHAR")
	    (define bchar  c-peek-char   (binput-port) "PEEK_CHAR")
	    (define bool   c-eof-object? (obj) "EOF_OBJECTP"))
   (export  (inline read/rp     grammar port)
	    (inline read/rp-ut  grammar port)
	    (inline read-char   . port)
	    (inline peek-char   . port)
	    (inline eof-object? port)
	    (inline read-string port number)
	    read-line))

;*---------------------------------------------------------------------*/
;*    read/rp ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (read/rp grammar port)
   (if (input-port? port)
       (grammar port)
       (failure "read/rp"
		(type-error 'binput-port 'port)
		port))) 

;*---------------------------------------------------------------------*/
;*    read/rp-ut ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (read/rp-ut grammar port)
   (grammar port))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (read-char . port)
   (let ((port (if (null? port)
		   (current-input-port)
		   (car port))))
      (c-read-char port)))
		   
;*---------------------------------------------------------------------*/
;*    peek-char ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (peek-char  . port)
   (let ((port (if (null? port)
		   (current-input-port)
		   (car port))))
      (c-peek-char port)))

;*---------------------------------------------------------------------*/
;*    eof-object? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (eof-object? object)
   (c-eof-object? object))

;*---------------------------------------------------------------------*/
;*    read-string ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (read-string input-port number)
   (c-input-port-read-string input-port number))

;*---------------------------------------------------------------------*/
;*    read-line ...                                                    */
;*---------------------------------------------------------------------*/
(define read-line
   (let ((grammar (regular-grammar ()
		     ((* (all))
		      (let ((string (the-string)))
			 (input-port-stole-char input-port)
			 string))
		     ((#\Newline)
		      ""))))
      (lambda (input-port)
	 (read/rp grammar input-port))))
