;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Ieee/control.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul  2 10:17:45 1992                          */
;*    Last change :  Mon May 16 16:51:31 1994 (serrano)                */
;*                                                                     */
;*    6.9. Control features (page 27, r4)                              */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_control_features_6_9
   (foreign (define bool c-procedure?          (obj) "PROCEDUREP")
	    (define bool c-procedure-light?    (obj) "PROCEDURE_LIGHTP")
	    (define bool va-procedure?         (bprocedure) "VA_PROCEDUREP")
	    (define obj  procedure-entry       (bprocedure) "PROCEDURE_ENTRY")
	    (define obj  procedure-light-entry (bprocedure)
	       "PROCEDURE_LIGHT_ENTRY")
	    (define long  procedure-arity      (bprocedure) "PROCEDURE_ARITY")
	    (define bool procedure-correct-arity?   (bprocedure long)
	                 "PROCEDURE_CORRECT_ARITYP")
	    (obj         c-make-procedure           (obj bint bint)
			 "make_procedure")
	    (bprocedure  make-fx-procedure          (obj long long)
			 "make_fx_procedure")
	    (bprocedure  make-extra-light-procedure (long)
			 "make_extra_light_procedure")
	    (bprocedure  make-light-procedure       (obj long)
			 "make_light_procedure")
	    (bprocedure  make-va-procedure          (obj long long)
			 "make_va_procedure")
	    (define obj procedure-env-set!          (bprocedure long obj)
	       "PROCEDURE_ENV_SET")
	    (define obj procedure-env-ref           (bprocedure long)
	       "PROCEDURE_ENV_REF")
	    (define obj procedure-light-env-set!    (obj long obj)
	       "PROCEDURE_LIGHT_ENV_SET")
	    (define obj procedure-light-env-ref     (obj long)
	       "PROCEDURE_LIGHT_ENV_REF")
	    (define obj procedure-extra-light-env-set!    (obj long obj)
	       "PROCEDURE_EXTRA_LIGHT_ENV_SET")
	    (define obj procedure-extra-light-env-ref     (obj long)
	       "PROCEDURE_EXTRA_LIGHT_ENV_REF")
	    (define obj make-cell (obj)           "MAKE_CELL")
	    (define obj cell-set! (obj obj)       "CELL_SET")
	    (define obj cell-ref  (obj)           "CELL_REF")
	    (define bool cell?    (obj)           "CELLP")
	    (obj call-cc          (bprocedure)    "call_cc")
	    (define obj unspec                    "BUNSPEC")
	    (define obj __eoa__                   "BEOA"))
   (export  (inline procedure?                     obj)
	    (inline make-procedure                 entry arity size)
	    (inline closure-arity                  proc)
	    (apply                                 proc obj1 . args)
	    (map                                   proc . list)
	    (map-2                                 proc list)
	    (for-each                              proc . list)
	    (for-each-2                            proc list)
	    (inline force                          promise)
	    (make-promise                          proc)
	    (inline call/cc                        proc)
            (inline unspecified)))

;*---------------------------------------------------------------------*/
;*    procedure? ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (procedure? obj)
   (c-procedure? obj))

;*---------------------------------------------------------------------*/
;*    make-procedure ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (make-procedure entry arity size)
   (c-make-procedure entry arity size))

;*---------------------------------------------------------------------*/
;*    closure-arity ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (closure-arity proc)
   (procedure-arity proc))

;*---------------------------------------------------------------------*/
;*    apply ...                                                        */
;*---------------------------------------------------------------------*/
(define (apply proc args . opt)
   (let ((args (if (pair? opt)
		   (cons args (let loop ((opt opt))
				 (if (pair? (cdr opt))
				     (cons (car opt) (loop (cdr opt)))
				     (car opt))))
		   args)))
      (apply proc args)))

;*---------------------------------------------------------------------*/
;*    map-2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (map-2 f l)
   (let loop ((l l))
      (if (null? l)
	  '()
	  (cons (f (car l)) (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    map ...                                                          */
;*---------------------------------------------------------------------*/
(define (map f . l)
   (cond
      ((null? l)
       '())
      ((null? (cdr l))
       (map-2 f (car l)))
      (else
       (let loop ((l l))
	  (if (null? (car l))
	      '()
	      (begin
		 (cons (apply f (map car l))
		       (loop (map cdr l)))))))))

;*---------------------------------------------------------------------*/
;*    for-each-2 ...                                                   */
;*---------------------------------------------------------------------*/
(define (for-each-2 f l)
   (let loop ((l l))
      (if (null? l)
	  '()
	  (begin
	     (f (car l))
	     (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    for-each ...                                                     */
;*---------------------------------------------------------------------*/
(define (for-each f . l)
   (cond
      ((null? l)
       '())
      ((null? (cdr l))
       (for-each-2 f (car l)))
      (else
       (let loop ((l l))
	  (if (null? (car l))
	      '()
	      (begin
		 (apply f (map car l))
		 (loop (map cdr l))))))))

;*---------------------------------------------------------------------*/
;*    force ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (force promise)
   (promise))

;*---------------------------------------------------------------------*/
;*    make-promise ...                                                 */
;*---------------------------------------------------------------------*/
(define (make-promise proc)
   (let ((result-ready? #f)
	 (result        #f))
      (lambda ()
	 (if result-ready?
	     result
	     (let ((x (proc)))
		(if result-ready?
		    result
		    (begin
		       (set! result-ready? #t)
		       (set! result x)
		       result))))))) 

;*---------------------------------------------------------------------*/
;*    call/cc ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (call/cc proc)
   (call-cc proc))

;*---------------------------------------------------------------------*/
;*    unspecified ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (unspecified)
   unspec) 

