/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.6/Clib/writer.c ...         */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Dec 17 09:44:20 1991                          */
/*    Last change :  Mon May 16 16:38:21 1994 (serrano)                */
/*                                                                     */
/*    On imprime les objets (non recursifs)                            */
/*---------------------------------------------------------------------*/
#include <stdio.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t c_constant_string_to_string();

/*---------------------------------------------------------------------*/
/*    Les noms des caracateres                                         */
/*---------------------------------------------------------------------*/
static char *char_name[] =
{
   "","","","","","","","",
   "",  "tab", "newline", "", "", "return", "", "",
   "", "","","","","","","",
   "", "", "","","", "", "", "",
   "space", "!", "\"","#","$","%","&","'",
   "(", ")", "*", "+", ",", "-", ".", "/",
   "0", "1", "2", "3", "4", "5", "6", "7",
   "8", "9", ":", ";", "<", "=", ">", "?",
   "@", "A", "B", "C", "D", "E", "F", "G",
   "H", "I", "J", "K", "L", "M", "N", "O",
   "P", "Q", "R", "S", "T", "U", "V", "W",
   "X", "Y", "Z", "[", "\\", "]", "^", "_",
   "`", "a", "b", "c", "d", "e", "f", "g",
   "h", "i", "j", "k", "l", "m", "n", "o",
   "p", "q", "r", "s", "t", "u", "v", "w",
   "x", "y", "z", "{", "|", "}", "~", ""
};


/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    strputc ...                                                      */
/*---------------------------------------------------------------------*/
obj_t
strputc( c, p )
char  c;
obj_t p;
{
	long offset;
	
	if( END_OF_STRING_PORTP( p ) )
	   strport_grow( p );

	offset = OUTPUT_STRING_PORT( p ).offset;

	OUTPUT_STRING_PORT( p ).buffer[ offset ] = c;
	OUTPUT_STRING_PORT( p ).offset = offset + 1;

	return p;
}
	
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    strputs ...                                                      */
/*---------------------------------------------------------------------*/
obj_t
strputs( s, p )
char *s;
obj_t p;
{
	long offset;
	long len;
	
	offset = OUTPUT_STRING_PORT( p ).offset;
	len    = strlen( s );

	while((OUTPUT_STRING_PORT( p ).offset+len) > OUTPUT_STRING_PORT( p ).size)
	   strport_grow( p );

	strcpy( &(OUTPUT_STRING_PORT( p ).buffer[ offset ]), s );

	OUTPUT_STRING_PORT( p ).offset = offset + len;

	return p;
}
	
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    write_object_s ...                                               */
/*---------------------------------------------------------------------*/
obj_t
write_object_s( o ,f )
obj_t o, f;
{
   if( INTEGERP( o ) )
   {
		char new[ 100 ];
		
      sprintf( new, "%d", CINT( o ) );

		strputs( new, f );
		
      return o;
   }
   else
      if( CHARP( o ) )
      {
         strputc( CCHAR( o ), f );
			
         return BUNSPEC;
      }
      else
         switch( (long)o )
         {
#if !(defined( ALLOCATE_CONSTANT ))
            case (long)BNIL :
               strputs( "()", f );
               return BNIL;

            case (long)BUNSPEC :
               strputs( "#UNSPECIFIED", f );
               return BUNSPEC;
            
            case (long)BFALSE :
               strputs( "#f", f );
               return BFALSE;
            
            case (long)BTRUE :
               strputs( "#t", f );
               return BTRUE;

            case (long)BEOF :
               strputs( "#<END-OF-FILE>", f);
               return BEOF;
#endif
               
            default :
				   if( CNSTP( o ) )
					{
						char aux[ 7 ];
						
						sprintf( aux, "#<%04x>", CCNST( o ) );
						strputs( aux, f );
						
						return o;
					}
					
               if( !POINTERP( o ) )
               {
						char aux[ 16 ];
						
						sprintf( aux, "#<???:%08x>", o );
                  strputs( aux, f );
                  return o;
               }
               else
                  switch( HEADER( o ) )
                  {
#if defined( ALLOCATE_CONSTANT )
                     case HEADER_TRUE :
                        strputs( "#t", f );
                        return BTRUE;
                        
                     case HEADER_FALSE :
                        strputs( "#f", f );
                        return BFALSE;
                  
                     case HEADER_NIL :
                        strputs( "", f );
                        return BNIL;
                  
                     case HEADER_UNDEF :
                        strputs( "#UNDEF", f );
                        return BUNSPEC;

                     case HEADER_EOF :
                        strputs( "#<END OF FILE>", f);
                        return BEOF;
#endif
                     case HEADER_STRING :
                        strputs( BSTRING_TO_CSTRING( o ), f );
                        return o;
               
                     case HEADER_SYMBOL :
                        strputs( SYMBOL( o ).name, f );
                        return o;
               
                     case HEADER_REAL :
							   {
									char new[ 100 ];
									
                           sprintf( new, "%#g", REAL( o ).real );
									strputs( new, f );
									
                           return o;
								}
								
                     case HEADER_PROCEDURE :
							   {
									char new[ 100 ];

									fprintf( new, "#<procedure:%x.%d>", o,
											   PROCEDURE( o ).arity );
									strputs( new, f );
									
                           return o;
								}
                  
                     case HEADER_OUTPUT_PORT :
							   {
									char new[ 100 ];
									
                           fprintf( new, "#<output_port:%s>",
                                    OUTPUT_PORT( o ).name );
									strputs( new, f );
									
                           return o;
								}

							case HEADER_OUTPUT_STRING_PORT :
                        strputs( "#<output_string_port>", f );
                        return o;
							
                     case HEADER_INPUT_PORT : 
							   {
									char new[ 500 ];
									
                           fprintf( new, "#<input_port:%x.%s.%d>",
                                    o,
                                    INPUT_PORT( o ).name,
                                    INPUT_PORT( o ).bufsiz );
									strputs( new,f );
									
                           return o;
								} 
               
						   case HEADER_CELL :
						      strputs( "#<cell:", f );
								write_object_s( CELL_REF( o ), f );
								strputs( ">", f );
								
								return o;

						   case HEADER_FOREIGN :
						      strputs( "#<type:", f );
								write_object_s( FOREIGN_ID( o ), f );
								strputs( ">", f );
								
								return o;
			
						   default :
						      {
									char aux[ 20 ];
						
									sprintf( aux, "#<???:%08x>", o );
									strputs( aux, f );
									return o;
								}								
							}
      }
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    write_object_f ...                                               */
/*---------------------------------------------------------------------*/
obj_t
write_object_f( o ,f )
obj_t o, f;
{
   FILE *fout = OUTPUT_PORT( f ).file;

   if( INTEGERP( o ) )
   {
      fprintf( fout, "%d", CINT( o ) );
		
      return o;
   }
   else
      if( CHARP( o ) )
      {
         fputc( CCHAR( o ), fout );
			
         return BUNSPEC;
      }
      else
         switch( (long)o )
         {
#if !(defined( ALLOCATE_CONSTANT ))
            case (long)BNIL :
               fputs( "()", fout );
               return BNIL;

            case (long)BUNSPEC :
               fputs( "#UNSPECIFIED", fout );
               return BUNSPEC;
            
            case (long)BFALSE :
               fputs( "#f", fout );
               return BFALSE;
            
            case (long)BTRUE :
               fputs( "#t", fout );
               return BTRUE;

            case (long)BEOF :
               fputs( "#<END OF FILE>", fout);
               return BEOF;
#endif
               
            default :
				   if( CNSTP( o ) )
					{
						fprintf( fout, "#<%04x>", CCNST( o ) );
						return o;
					}
					
					if( !POINTERP( o ) )
               {
						fprintf( fout, "#<???:%08x>", o );
                  return o;
               }
               else
                  switch( HEADER( o ) )
                  {
#if defined( ALLOCATE_CONSTANT )
                     case HEADER_TRUE :
                        fputs( "#t", fout );
                        return BTRUE;
                        
                     case HEADER_FALSE :
                        fputs( "#f", fout );
                        return BFALSE;
                  
                     case HEADER_NIL :
                        fputs( "", fout );
                        return BNIL;
                  
                     case HEADER_UNDEF :
                        fputs( "#UNDEF", fout );
                        return BUNSPEC;

                     case HEADER_EOF :
                        fputs( "#<END OF FILE>", fout);
                        return BEOF;
#endif
                     case HEADER_STRING :
                        fputs( BSTRING_TO_CSTRING( o ), fout );
                        return o;
               
                     case HEADER_SYMBOL :
                        fputs( SYMBOL( o ).name, fout );
                        return o;
               
                     case HEADER_REAL :
                        fprintf( fout, "%#g", REAL( o ).real );
                        return o;
               
                     case HEADER_PROCEDURE :
                        fprintf( fout, "#<procedure:%x.%d>", o,
                                 PROCEDURE( o ).arity );
                        return o;
                  
                     case HEADER_OUTPUT_PORT :
                        fprintf( fout, "#<output_port:%s>",
                                 OUTPUT_PORT( o ).name );
                        return o;
                     
                     case HEADER_OUTPUT_STRING_PORT :
                        fputs( "#<output_string_port>", fout );
                        return o;
							
                     case HEADER_INPUT_PORT :
                        fprintf( fout, "#<input_port:%x.%s.%d>",
                                 o,
                                 INPUT_PORT( o ).name,
                                 INPUT_PORT( o ).bufsiz );
                        return o;
               
						   case HEADER_CELL :
							   fputs( "#<cell:", fout );
								write_object_f( CELL_REF( o ), f );
								fputs( ">", fout );
								
								return o;

						   case HEADER_FOREIGN :
							   fputs( "#<type:", fout );
								write_object_f( FOREIGN_ID( o ), f );
								fputs( ">", fout );
								
								return o;
			
						   default :
			               {
									fprintf( fout, "#<???:%08x>", o );
									return o;
								}		
            }
      }
}

/*---------------------------------------------------------------------*/
/*    write_object ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_object( o, f )
obj_t o, f;
{
	if( OUTPUT_STRING_PORTP( f ) )
	   return write_object_s( o, f );
	else
	   return write_object_f( o, f );
}

/*---------------------------------------------------------------------*/
/*    write_string_f ...                                               */
/*---------------------------------------------------------------------*/
obj_t
write_string_f( string, port )
obj_t string, port;
{
   FILE *fout = OUTPUT_PORT( port ).file;
   char *aux  = BSTRING_TO_CSTRING( string );
   
   fputc( '"', fout );
   fputs( aux, fout );
   fputc( '"', fout );
   return string;
}

/*---------------------------------------------------------------------*/
/*    write_string_s ...                                               */
/*---------------------------------------------------------------------*/
obj_t
write_string_s( string, port )
obj_t string, port;
{
   char *aux  = BSTRING_TO_CSTRING( string );
   
   strputc( '"', port );
   strputs( aux, port );
   strputc( '"', port );
	
   return string;
}

/*---------------------------------------------------------------------*/
/*    write_string ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_string( string, port )
obj_t string, port;
{
	if( OUTPUT_STRING_PORTP( port ) )
	   write_string_s( string, port );
	else
	   write_string_f( string, port );
}

/*---------------------------------------------------------------------*/
/*    write_char_f ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_char_f( c, port )
obj_t c, port;
{
   FILE *f = OUTPUT_PORT( port ).file;
	
   if( (CCHAR( c ) < 127) && (char_name[ CCHAR( c ) ][ 0 ]) )
		fprintf( f, "#\\%s", char_name[ CCHAR( c ) ] );
	else
		fprintf( f, "#a%03d", CCHAR( c ) );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    write_char_s ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
write_char_s( c, port )
obj_t c, port;
{

   if( (CCHAR( c ) < 127) && (char_name[ CCHAR( c ) ][ 0 ]) )
	{
     		
		strputs( "#\\", port );
		strputs( char_name[ CCHAR( c ) ] );
	}
	else
	{
		char aux[ 10 ];
		
		sprintf( aux, "#a%03d", CCHAR( c ) );
		strputs( aux, port );
	}
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    write_char ...                                                   */
/*---------------------------------------------------------------------*/
obj_t
write_char( c, port )
obj_t c, port;
{
	if( OUTPUT_STRING_PORTP( port ) )
	   return write_char_s( c, port );
	else
	   return write_char_f( c, port );
}   

/*---------------------------------------------------------------------*/
/*    ill_char_rep ...                                                 */
/*---------------------------------------------------------------------*/
obj_t
ill_char_rep( c )
obj_t c;
{
   char aux[ 10 ];

   sprintf( aux, "#a%03d", CCHAR( c ) );

   return c_constant_string_to_string( aux );
}
