;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/vector.scm ...               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 09:39:09 1992                          */
;*    Last change :  Mon Jun  7 20:29:35 1993  (serrano)               */
;*                                                                     */
;*    On test les operations primitives sur les vecteurs               */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module vector
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-vector)))

;*---------------------------------------------------------------------*/
;*    test-vector ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-vector)
   (test-module "vector" "vector.scm" #f)
   (test "vector?" (vector? '#()) #t)
   (test "vector?" (vector? '#(1)) #t)
   (test "ref" (vector-ref '#(1 2 3 4) 2) 3)
   (test "set" (let ((v (make-vector 1 '())))
		  (vector-set! v 0 'toto)
		  (vector-ref  v 0))
	 'toto)
   (test "length" (vector-length '#(1 2 3 4 5)) 5)
   (test "length" (vector-length (make-vector 5 'toto)) 5)
   (test "equal vector" (let ((v (make-vector 3 '())))
			   (vector-set! v 0 '(1 2 3))
			   (vector-set! v 1 '#(1 2 3))
			   (vector-set! v 2 'hello)
			   v)
	 '#((1 2 3) #(1 2 3) hello))
   (test "vector-fill" (let ((v (make-vector 3 1)))
			  (vector-fill! v 2)
			  (+ (vector-ref v 0)
			     (vector-ref v 1)
			     (vector-ref v 2)))
	 6))

