;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/port.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 24 10:56:01 1992                          */
;*    Last change :  Tue Jan 11 11:21:50 1994 (serrano)                */
;*                                                                     */
;*    On test les operations simples sur les ports                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module input-port
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-input-port)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 port)
   (labels ((get-char (n)
		      (let loop ((i 1)
				 (r (read-char port)))
			 (if (= i n)
			     r
			     (loop (+ 1 i)
				   (read-char port)))))
	    (stole-char (n)
			(let loop ((i 1)
				   (r (peek-char port)))
			   (if (= i n)
			       r
			       (loop (+ 1 i)
				     (peek-char port))))))
      (get-char 10)
      (stole-char 10)
      (get-char 30)
      (stole-char 1) 
      (get-char 33)))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 string len)
   (let ((port (open-input-file string len)))
      (if (not (input-port? port))
	  #f
	  (labels ((get-char (n)
			     (let loop ((i 1)
					(r (read-char port)))
				(if (= i n)
				    r
				    (loop (+ 1 i)
					  (read-char port)))))
		   (stole-char (n)
			       (let loop ((i 1)
					  (r (peek-char port)))
				  (if (= i n)
				      r
				      (loop (+ 1 i)
					    (peek-char port))))))
	     (get-char 10)
	     (stole-char 10)
	     (get-char 30)
	     (stole-char 1)
	     (let ((res (get-char 33)))
		(close-input-port port)
		res)))))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3 string)
   (let ((port (open-input-string string)))
      (let ((exp (read port)))
	 exp)))

;*---------------------------------------------------------------------*/
;*    test-input-port ...                                              */
;*---------------------------------------------------------------------*/
(define (test-input-port)
   (test-module "test-input-port" "port.scm" #f)
   (test "input" (open-input-file "wrong") (input-port? #\space))
   (test "input" (call-with-input-file "misc/input.txt" test1) #\.)
   (test "input" (test2 "misc/input.txt" 10) #\.)
   (test "input-string" (test3 "(4 5 (3) #(1 2 3) \"toto\" titi)")
	 '(4 5 (3) #(1 2 3) "toto" titi)))
