;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/inline.scm ...               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov  6 10:40:50 1992                          */
;*    Last change :  Fri Jul 16 16:56:29 1993  (serrano)               */
;*                                                                     */
;*    Des petits tests qui verifie que l'inlining se fait              */
;*    convenablement.                                                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module inline
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-inline)))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(define (foo a)
   (define (hux x)
      (let* ((formal (cadr x)))
	 formal))
   hux)
 
;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*---------------------------------------------------------------------*/
(define bar
   (let ((a 1))
      (lambda ()
	 (set! a (+ 1 a))
	 (list a a a a))))
 
;*---------------------------------------------------------------------*/
;*    hux ...                                                          */
;*---------------------------------------------------------------------*/
(define (hux)
   (cadr (bar)))

;*---------------------------------------------------------------------*/
;*    loop ...                                                         */
;*---------------------------------------------------------------------*/
(define (loop x . y)
   (if (>fx x 1)
       (loop 1 y)
       y))

;*---------------------------------------------------------------------*/
;*    loop2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (loop2 n s1 s2 test)
   (if (=fx n 0)
       'done
       (loop2 (-fx n 1) s1 s2 (equal? s1 s2))))

;*---------------------------------------------------------------------*/
;*    test-inline ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-inline)
   (test-module "inline" "inline.scm" #f)
   (test "inline" ((foo 1) '(1 2 3 4)) 2)
   (test "type-rq" (hux) 2)
   (test "loop" (loop 2 2) '((2)))
   (test "loop" (loop2 10 2 2 #f) 'done))
