;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/examples/Afile/afile.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:49:15 1993                          */
;*    Last change :  Wed Mar 17 11:14:40 1993  (serrano)               */
;*                                                                     */
;*    On genere un `.afile' compose de tous les arguments              */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module afile (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (if (or (null?    (cdr argv))
	   (string=? (cadr argv) "-help"))
       (usage)
       (let loop ((files        (cdr argv))
		  (access-list '())
		  (output-file '()))
	  (cond
	     ((null? files)
	      (output access-list output-file))
	     ((string=? (car files) "-o")
	      (if (null? (cdr files))
		  (usage)
		  (loop (cddr files)
			access-list
			(cadr files))))
	     (else
	      (loop (cdr files)
		    (cons (car files) access-list)
		    output-file))))))

;*---------------------------------------------------------------------*/
;*    output ...                                                       */
;*---------------------------------------------------------------------*/
(define (output access-list output-file)
   (let ((port (if (string? output-file)
		   (begin
		      (if (file-exists? output-file)
			  (rename-file output-file
				       (string-append output-file "~")))
		      (open-output-file output-file))
		   (current-output-port))))
      (fprint port
	      ";; " (getenv "PWD") #\Newline
	      ";; " (date) #\Newline
	      #\()
      (let loop ((access-list access-list))
	 (if (null? access-list)
	     (fprint port #\) #\Newline)
	     (begin
		(fprint port
			"  ("
			(string-downcase
			 (symbol->string (find-module-name (car access-list))))
			" "
			#\" (car access-list) #\" #\))
		(loop (cdr access-list)))))))
	  
;*---------------------------------------------------------------------*/
;*    find-module-name ...                                             */
;*---------------------------------------------------------------------*/
(define (find-module-name file)
   (if (not (file-exists? file))
       (begin
	  (fprint (current-error-port) "*** ERROR:afile:" #\Newline
		  "Can't find file -- " file)
	  'no-such-module)
       (let ((port (open-input-file file)))
	  (if (not (input-port? port))
	      (begin
		 (fprint (current-error-port) "*** ERROR:afile:" #\Newline
			 "Can't open file -- " file)
		 'no-such-module)
	      (let ((exp (read port)))
		 (match-case exp
		    ((module ?module-name . ?-)
		     (close-input-port port)
		     module-name)
		    (else
		     (close-input-port port)
		     (fprint (current-error-port) "*** ERROR:afile:" #\Newline
			     "Illegal file format -- " file)
		     'illegal-file-format)))))))
	     
;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: afile [-o output] <file1> <file2> ... <filen>")
   (exit -1))
