;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Write/c.scm ...          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 10:00:25 1993                          */
;*    Last change :  Sat Apr  3 10:13:31 1993  (serrano)               */
;*                                                                     */
;*    Des utilitaires d'ecriture de C                                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module write_c
   (export (write-c-comment port string fill col)))

;*---------------------------------------------------------------------*/
;*    write-c-comment ...                                              */
;*---------------------------------------------------------------------*/
(define (write-c-comment port string fill col)
   (display "/*" port)
   (let ((len (string-length string)))
      (if (=fx len 0)
	  (fprint port (make-string (-fx col 4) fill) "*/")
	  (begin
	     (display (make-string 2 fill) port)
	     (display #\space port)
	     (display string port)
	     (display #\space port)
	     (fprint port (make-string (-fx col (+ 8 len)) fill) "*/")))))
