;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Parse/import.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 16 17:06:26 1992                          */
;*    Last change :  Thu Jan 20 09:33:47 1994 (serrano)                */
;*                                                                     */
;*    On parse les directives d`importations. Ce travail n'est pas     */
;*    simple car il faut dans certain cas aller ouvrir les             */
;*    fichier importes pour lire les declarations et,                  */
;*    eventuellement les definitions des inlines.                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_import
   (import read_access
	   read_import
	   var_declare)
   (export (parse-import   clauses)
	   (parse-imported p m)))

;*---------------------------------------------------------------------*/
;*    parse-import ...                                                 */
;*    -------------------------------------------------------------    */
;*    La syntaxe d'une clause d'importation est assez complexe:        */
;*    import ::  module-name                |                          */
;*               (module-name "file-name")  |                          */
;*               (variable module-name)     |                          */
;*               (variable module-name "file-name")                    */
;*---------------------------------------------------------------------*/
(define (parse-import imports)
   (if (null? imports)
       'done
;*---------------------------------------------------------------------*/
;*    On commence par calculer la liste de tous les modules qu'il faut */
;*    importer. En plus de cette liste, on calcule la liste des        */
;*    liaisons qu'il faut importer pour chaque module.                 */
;*---------------------------------------------------------------------*/
       (let loop ((imports  imports)
		  (imported '()))
;*---------------------------------------------------------------------*/
;*    Ca y est, la liste est calculee. On va maintenant lire les       */
;*    fichiers a importer                                              */
;*---------------------------------------------------------------------*/
	  (if (null? imports)
	      (read-all-imported-module imported)
;*---------------------------------------------------------------------*/
;*    On parse une clause                                              */
;*---------------------------------------------------------------------*/
	      (match-case (car imports)
		 ((?first ?second)
		  (cond
		     ((string? second)
		      ;; (module-name "file-name")
		      (begin
			 (add-access! first second)
			 (let ((b (assq first imported)))
			    (if b
				(begin
				   (set-cdr! b '())
				   (loop (cdr imports) imported))
				(loop (cdr imports)
				      (cons (cons first '())
					    imported))))))
		     (else
		      ;; (variable module-name)
		      (let ((b (assq second imported)))
			 (if (not b)
			     (loop (cdr imports)
				   (cons (cons second (list first))
					 imported))
			     (if (null? (cdr b))
				 (loop (cdr imports) imported)
				 (begin
				    (if (not (memq first (cdr b)))
					(set-cdr! b (cons first
							  (cdr b))))
				    (loop (cdr imports)
					  imported))))))))
		 ((?var ?module ?file)
		  ;; (variable module-name "file-name") 
		  (if (not (string? file))
		      (error "parse-import"
			     "Illegal import clause"
			     (car imports))
		      (begin
			 (add-access! module file)
			 (let ((b (assq module imported)))
			    (if (not b)
				(loop (cdr imports)
				      (cons (cons module (list var))
					    imported))
				(if (null? (cdr b))
				    (loop (cdr imports) imported)
				    (begin
				       (if (not (memq var (cdr b)))
					   (set-cdr! b (cons var
							     (cdr b))))
				       (loop (cdr imports)
					     imported))))))))
		 ((and (not (?- . ?-)) ?module)
		  ;; module-name
		  (let ((b (assq module imported)))
		     (if b
			 (begin
			    (set-cdr! b '())
			    (loop (cdr imports) imported))
			 (loop (cdr imports)
			       (cons (cons (car imports) '())
				     imported)))))
		 (else
		  (error "parse-import"
			 "Illegal clause" (car imports))))))))
			   
;*---------------------------------------------------------------------*/
;*    parse-imported ...                                               */
;*    -------------------------------------------------------------    */
;*    Cette fonction est differente de la precedente. Ici, on parse    */
;*    une clause d'un module importe et non la clause d'importation    */
;*    du module qu'on est en train de compiler.                        */
;*---------------------------------------------------------------------*/
(define (parse-imported provided module)
   (match-case provided
      ((inline (and (? symbol?) ?name) . ?args)
       (declare-global-inline! name args module 'import)
       name)
      (((and (? symbol?) ?name) . ?args)
       (declare-global-procedure! name args module 'import)
       #f)
      ((and (not (?- . ?-)) (and (? symbol?) ?name))
       (declare-global-variable! name module 'import)
       #f)
      ((main (and (? symbol?) ?name))
       (declare-global-procedure! name '(argv) module 'import)
       #f)
      (else
       (error "parse-imported"
	      "Illegal export clause"
	      provided))))

   
