;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Lift/fgraph.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  9 11:39:25 1993                          */
;*    Last change :  Wed Apr 27 18:53:24 1994 (serrano)                */
;*                                                                     */
;*    Le parcours de detection des variables libres                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_fgraph
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    lift_closure)
   (export (free-graph! exp owner integrator)))

;*---------------------------------------------------------------------*/
;*    free-graph! ...                                                  */
;*    -------------------------------------------------------------    */
;*    On annote l'arbre en marquant pour chaque variable locale, sont  */
;*    proprietaires et dans quelle fonction globalisee elle est        */
;*    definie.                                                         */
;*---------------------------------------------------------------------*/
(define (free-graph! exp owner integrator)
   (trace (lift loop) "free-graph!: " (shape exp) #\Newline
	  "      owner: " (shape owner) #\Newline
	  " integrator: " (shape integrator) #\Newline)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       'done)
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (if (local? exp)
	   (mark-local! exp owner)))
;*--- function --------------------------------------------------------*/
      (((or function function-extra-light function-light) ?-)
       (if (local? (cadr exp))
	   (mark-local! (cadr exp) owner)))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       'done)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       'done)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (free-hook-graph! (cdr exp) owner integrator))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (free-graph! (cadr exp) owner integrator)
       (free-graph! (caddr exp) owner integrator))
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (free-hook-graph! (cdr exp) owner integrator))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (free-graph! test owner integrator)
       (let loop ((clauses clauses))
	  (if (null? clauses)
	      'done
	      (begin
		 (free-graph! (cadr (car clauses)) owner integrator)
		 (loop (cdr clauses))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (free-hook-graph! (cdr exp) owner integrator))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       ;; on ajoute toutes les variables du `let' dans la liste
       ;; des variables definies par l'integrator et on ajuste les owner
       ;; des liaisons.
       (if (local? integrator)
	   (for-each (lambda (b)
			(lift-bind-set!
			 (local-info integrator)
			 (cons (car b) (lift-bind (local-info integrator)))))
		     (cadr exp)))
       ;; on descend dans les liaisons
       (let loop ((bindings (cadr exp)))
	  (if (null? bindings)
	      (free-graph! (caddr exp) owner integrator )
	      (begin
		 (lift-owner-set! (local-info (car (car bindings))) owner)
		 (free-graph! (cadr (car bindings)) owner integrator)
		 (loop (cdr bindings))))))
;*--- labels ----------------------------------------------------------*/
      ((labels . ?-)
       ;; on ajoute toutes les variables du `labels' dans la liste
       ;; des variables definies par l'integrator et on ajuste les owner
       ;; des liaisons.
       (if (local? integrator)
	   (for-each (lambda (b)
			;; on est oblige de calculer cet ensemble
			;; car certaine fonction qui s'enfuie peuvent
			;; capturer des variables et ne jamais etre
			;; appellees. Comme les variables capturees devront
			;; remonter dans la fonction definitions des fonctions,
			;; il faut marquer le lien entre l'englobant et la
			;; fonction.
			;; Je ne fais pas de test de presence des variables
			;; car avant d'utiliser cette liste, je vais passer
			;; dans la fonction `ajust-bind-escaping!'
			(if (function-escape? (local-value (car b)))
			    (lift-bind-escaping-set!
			     (local-info integrator)
			     (cons (car b) (lift-bind-escaping
					    (local-info integrator)))))
			(if (not (eq? integrator (car b)))
			    (lift-bind-set!
			     (local-info integrator)
			     (cons (car b)
				   (lift-bind (local-info integrator))))))
		     (cadr exp)))
       (for-each (lambda (b)
		    (lift-owner-set! (local-info (car b)) owner))
		 (cadr exp))
       ;; on descend dans les liaisons
       (let loop ((bindings (cadr exp)))
	  (if (null? bindings)
	      (free-graph! (caddr exp) owner integrator)
	      (let* ((var     (car (car bindings)))
		     (formals (cadr (car bindings)))
		     (body    (caddr (car bindings)))
		     (new-I   (cond
				 ((lift-G? (local-info var))
				  var)
				 (else
				  (lift-integrator (local-info var))))))
		 ;; on marque le owner des arguments
		 (for-each (lambda (f) (lift-owner-set! (local-info f) var))
			   formals)
		 ;; on ajoute les formels comme etant definies par new-I
		 (if (local? new-I)
		     (begin
			(lift-bind-set!
			 (local-info new-I)
			 (append formals (lift-bind (local-info new-I))))))
		 ;; on examine le corps
		 (free-graph! body var new-I)
		 (loop (cdr bindings))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (lift-owner-set! (local-info (cadr exp)) owner)
       (let ((new-I (if (lift-G? (local-info (cadr exp)))
			(cadr exp)
			(lift-integrator (local-info (cadr exp))))))
	  (if (and (local? new-I)
		   (not (eq? new-I (cadr exp))))
	      (lift-bind-set! (local-info new-I)
			      (cons (cadr exp)
				    (lift-bind (local-info new-I)))))
	  (free-graph! (caddr exp) (cadr exp) new-I)))
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (free-hook-graph! (cdr exp) owner integrator))
;*--- apply & funcall -------------------------------------------------*/
      (((or apply funcall) . ?-)
       (free-hook-graph! (cdr exp) owner integrator))
;*--- funcall-extra-light ---------------------------------------------*/
      (((funcall-extra-light . ?-) . ?-)
       (free-hook-graph! (cdr exp) owner integrator))
;*--- application -----------------------------------------------------*/
      ((?fun . ?args)
       (if (local? fun)
	   (if (or (and (eq? (local-class fun) 'function)
			(function-escape? (local-value fun)))
		   (and (eq? (local-class fun) 'return)
			(lift-G? (local-info fun))))
	       (mark-local! fun owner)))
       (free-hook-graph! args owner integrator))))

;*---------------------------------------------------------------------*/
;*    free-hook-graph! ...                                             */
;*---------------------------------------------------------------------*/
(define (free-hook-graph! exp owner integrator)
   (let loop ((exp exp))
      (if (null? exp)
	  'done
	  (begin
	     (free-graph! (car exp) owner integrator)
	     (loop (cdr exp))))))
      
;*---------------------------------------------------------------------*/
;*    mark-local! ...                                                  */
;*---------------------------------------------------------------------*/
(define (mark-local! local owner)
   (cond
      ((not (local? owner))
       ;; owner n'est pas locale, on saute
       'ok)
      ((or (eq? local owner)
	   (eq? (lift-owner (local-info local)) owner))
       ;; c'est une variable liee, on saute
       'ok)
      (else
       ;; ok, on l'ajoute a la liste des variables libres
       (lift-free-set! (local-info owner)
		       (cons local (lift-free (local-info owner))))
       ;; on boucle sur les parents
       (let ((local-owner (lift-owner (local-info local))))
	  (let loop ((owner (lift-owner (local-info owner))))
	     (trace lift "mark-local(loop) : " (shape local) " " (shape owner)
		    #\Newline)
	     (if (or (eq? owner local-owner)
		     (eq? owner local))
		 'ok
		 (begin
		    (lift-free-set! (local-info owner)
				    (cons local
					  (lift-free (local-info owner))))
		    (loop (lift-owner (local-info owner))))))))))

   
