;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Lift/cgraph.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 29 17:08:31 1993                          */
;*    Last change :  Tue Dec 14 16:11:06 1993 (serrano)                */
;*                                                                     */
;*    Le calcul du graphe d'appel                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_cgraph
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape)
   (export  (call-graph! body  caller G0)
	    (make-local-lift!  local)))

;*---------------------------------------------------------------------*/
;*    call-graph! ...                                                  */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne G0, les fonctions a globaliser au premier*/
;*    rang. Et en plus elle instrument le code en creant des structures*/
;*    `lift' pour les fonctions locales. Ces structures contiennent    */
;*    le graphe d'appel.                                               */
;*    -------------------------------------------------------------    */
;*    On profite de cette passe pour re-ajuster les champs `body' et   */
;*    `args' des fonctions locales.                                    */
;*---------------------------------------------------------------------*/
(define (call-graph! exp caller G0)
   (trace (loop lift) "call-graph: " (shape exp) #\Newline)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       G0)
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       G0)
;*--- function --------------------------------------------------------*/
      (((or function function-extra-light function-light) ?var)
       (if (local? var)
	   (let ((info (local-info var)))
	      (if (>=fx (function-arity (local-value var)) 0)
		  (case (car exp)
		     ((function-extra-light)
		      (lift-0cfa-strength-set! info 'extra-light))
		     ((function-light)
		      (lift-0cfa-strength-set! info 'light))
		     (else
		      (lift-0cfa-strength-set! info 'strong)))
		  (lift-0cfa-strength-set! info 'strong))
	      (if (lift-G? (local-info (cadr exp)))
		  G0
		  (begin
		     (lift-G?-set! (local-info (cadr exp)) #t)
		     (function-escape?-set! (local-value (cadr exp)) #t)
		     (cons (cadr exp) G0))))
	   G0))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       G0)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       G0)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (call-hook-graph! (cdr exp) caller G0))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (call-graph! (caddr exp) caller G0))
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (call-hook-graph! (cdr exp) caller G0))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (let loop ((G       (call-graph! test caller G0))
		  (clauses clauses))
	  (if (null? clauses)
	      G
	      (loop (call-graph! (cadr (car clauses)) caller G)
		    (cdr clauses)))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (call-hook-graph! (cdr exp) caller G0))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (let loop ((hook (cadr exp))
		  (G0   G0))
	  (if (null? hook)
	      (call-graph! (caddr exp) caller G0)
	      (begin
		 (make-local-lift! (car (car hook)))
		 (loop (cdr hook)
		       (call-graph! (cadr (car hook)) caller G0))))))
;*--- labels ----------------------------------------------------------*/
      ((labels . ?-)
       ;; on definie les lift de toutes les liaisons
       (for-each (lambda (b)
		    (make-local-lift! (car b))
		    (function-escape?-set! (local-value (car b)) #f))
		 (cadr exp))
       ;; on boucle sur toutes les liaisons
       (let loop ((hook (cadr exp))
		  (G0   G0))
	  (if (null? hook)
	      (call-graph! (caddr exp) caller G0)
	      (begin
		 (for-each make-local-lift! (cadr (car hook)))
		 (function-args-set! (local-value (car (car hook)))
				     (cadr (car hook)))
		 (function-body-set! (local-value (car (car hook)))
				     (caddr (car hook)))
		 (loop (cdr hook)
		       (call-graph! (caddr (car hook))
				    (car (car hook))
				    G0))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (make-local-lift! (cadr exp))
;*---------------------------------------------------------------------*/
;*    !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!  */
;*    -------------------------------------------------------------    */
;*    J'ai fais cette modif le `Tue Dec 14 16:08:52 MET 1993', elle    */
;*    est accompagnee d'une autre modif dans le fichier kapture.scm.   */
;*---------------------------------------------------------------------*/
       (save-call! caller (cadr exp))
;*---------------------------------------------------------------------*/
       (return-body-set! (local-value (cadr exp)) (caddr exp))
       ;; il faut marquer ici la propriete `escape' car les block
       ;; n'apparaissent jamais comme `(function ?)' puisqu'on a fait
       ;; une beta-reduction dans la passe`Type'
       (if (return-escape? (local-value (cadr exp)))
	   (begin
	      (lift-G?-set! (local-info (cadr exp)) #t)
	      (call-graph! (caddr exp) (cadr exp) (cons (cadr exp) G0)))
	   (call-graph! (caddr exp) (cadr exp) G0)))
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (save-call! caller (cadr exp))
       (call-graph! (caddr exp) caller G0))
;*--- apply & funcall -------------------------------------------------*/
      (((or apply funcall funcall-medium funcall-light) . ?-)
       (call-hook-graph! (cdr exp) caller G0))
;*--- funcall-extra-light ---------------------------------------------*/
      (((funcall-extra-light . ?var) . ?-)
       (if (and (local? var)
		(not (lift? (local-info var))))
	   (make-local-lift! var)) 
       (call-hook-graph! (cdr exp) caller G0))
;*--- application -----------------------------------------------------*/
      ((?fun . ?args)
       (save-call! caller fun)
       (call-hook-graph! args caller G0))))

;*---------------------------------------------------------------------*/
;*    call-hook-graph! ...                                             */
;*---------------------------------------------------------------------*/
(define (call-hook-graph! exp caller G0)
   (if (null? exp)
       G0
       (call-hook-graph! (cdr exp) caller (call-graph! (car exp) caller G0))))

;*---------------------------------------------------------------------*/
;*    save-call!                                                       */
;*---------------------------------------------------------------------*/
(define (save-call! caller callee)
   (trace (loop lift)
	  "save-call!: " (shape caller) " <-> " (shape callee) #\Newline)
   (cond
      ((global? callee)
       'ok)
      ((global? caller)
       (let ((callee-lift (local-info callee)))
	  (if (not (memq caller (lift-cfrom callee-lift)))
	      (begin
		 (lift-cfrom-set! callee-lift
				  (cons caller (lift-cfrom callee-lift)))
		 (global-info-set! caller
				   (cons callee (global-info caller)))))))
      (else
       (let ((caller-lift (local-info caller))
	     (callee-lift (local-info callee)))
	  (if (not (memq caller (lift-cfrom callee-lift)))
	      (begin
		 (lift-cfrom-set! callee-lift
				  (cons caller (lift-cfrom callee-lift)))
		 (lift-cto-set! caller-lift
				(cons callee (lift-cto caller-lift)))))))))

;*---------------------------------------------------------------------*/
;*    get-info ...                                                     */
;*---------------------------------------------------------------------*/
(define (get-info var)
   (if (local? var)
       (local-info var)
       (global-info var)))
   
;*---------------------------------------------------------------------*/
;*    make-local-lift! ...                                             */
;*---------------------------------------------------------------------*/
(define (make-local-lift! local)
   (let ((new (make-lift)))
      (lift-G?-set!        new #f)
      (lift-kaptured-set!  new #f)
      (lift-kaptured?-set! new #f)
      (local-info-set! local new)
      new))
