;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.6/Integ/kk.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 15 11:15:48 1993                          */
;*    Last change :  Thu Jan 20 02:18:23 1994 (serrano)                */
;*                                                                     */
;*    Les calculs de K et K*                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_kk
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Integ/integ.sch")
   (import  tools_shape
	    integ_agraph)
   (export  (K! A var)
	    (K*! A-tail)))

;*---------------------------------------------------------------------*/
;*    K! ...                                                           */
;*    -------------------------------------------------------------    */
;*    La facon de calculer la propriete K est la suivante:             */
;*       1- On parcours la liste des A pour trouver tous               */
;*          les appels non-terminaux.                                  */
;*       2- On re-parcours A pour s'occuper des terminaux sachant      */
;*          que l'application de la troisieme regle declenche          */
;*          le re-ajustage de K pour une et une seule fonction.        */
;*    -------------------------------------------------------------    */
;*    Les trois regles sont (Seniak, page 101):                        */
;*       1.  E(f)                 ==> K(f, bottom)                     */
;*       2.  A(f,g,k)             ==> k(g,k)                           */
;*       3.  A(f,g,tail) ^ k(f,k) ==> k(g,k)                           */
;*    -------------------------------------------------------------    */
;*    En fait, on calcule en meme temps que la propriete K, la premiere*/
;*    regle de la propriete K*                                         */
;*---------------------------------------------------------------------*/
(define (K! A var)
;*---------------------------------------------------------------------*/
;*    1.  on sait qu'une seule fonction est E car toutes les autres    */
;*    ont deja ete globalisees (par lift).                             */
;*---------------------------------------------------------------------*/
   (let ((integ (if (global? var)
		    (global-info var)
		    (local-info var))))
      (integ-K-set!  integ (list 'bottom))
      (integ-K*-set! integ (list 'bottom))
      (K.2! A (K.1! A '()))))

;*---------------------------------------------------------------------*/
;*    K.1! ...                                                         */
;*---------------------------------------------------------------------*/
(define (K.1! A A-tail)
   (if (null? A)
       A-tail
       (let* ((pr (car A))
	      (f  (car pr))
	      (g  (cadr pr))
	      (k  (caddr pr)))
	  (cond
	     ((eq? k 'tail)
	      (if (eq? f g)
		  (K.1! (cdr A)
			A-tail)
		  (K.1! (cdr A)
			(cons pr A-tail))))
	     ((eq? k 'escape)
	      (K.1! (cdr A) A-tail))
	     (else
	      (let ((integ (if (local? g)
			       (local-info g)
			       (global-info g))))
		 (if (memq k (integ-K integ))
		     (K.1! (cdr A) A-tail)
		     (begin
			(integ-K-set!  integ (cons k (integ-K integ)))
			(integ-K*-set! integ (cons k (integ-K* integ)))
			(K.1! (cdr A) A-tail)))))))))
   
;*---------------------------------------------------------------------*/
;*    K.2! ...                                                         */
;*---------------------------------------------------------------------*/
(define (K.2! A A-tail)
   (let loop ((continue #t))
      (if (not continue)
	  A-tail
	  (let liip ((At       A-tail)
		     (continue #f))
	     (if (null? At)
		 (loop continue)
		 (let ((integ (if (local? (car (car At)))
				  (local-info (car (car At)))
				  (global-info (car (car At))))))
		    (if (null? (integ-K integ))
			(liip (cdr At) continue)
			(let* ((g      (cadr (car At)))
			       (ginteg (if (local? g)
					   (local-info g)
					   (global-info g))))
			   (let laap ((Ks       (integ-K integ))
				      (continue continue))
			      (if (null? Ks)
				  (liip (cdr At) continue)
				  (let ((k (car Ks)))
				     (if (memq k (integ-K ginteg))
					 (laap (cdr Ks) continue)
					 (begin
					    (integ-K-set! ginteg
							  (cons k (integ-K
								   ginteg)))
					    (integ-K*-set! ginteg
							   (cons k (integ-K*
								    ginteg)))
					    (laap (cdr Ks) #t))))))))))))))

;*---------------------------------------------------------------------*/
;*    K*! ...                                                          */
;*    -------------------------------------------------------------    */
;*    Les regles qui definissent la propriete K* sont:                 */
;*       1. K(f,g)                ==> K*(f,g)                          */
;*       2. A(f,g,tail) ^ K*(g,k) ==> K*(f,k)                          */
;*    Pour trouver des informations plus precises, se referer a la     */
;*    these Nitsan Seniak, page 102.                                   */
;*    -------------------------------------------------------------    */
;*    On a ete un tout petit peu malin car la premiere regle a deja    */
;*    ete traite lors du calcul de K.                                  */
;*---------------------------------------------------------------------*/
(define (K*! A-tail)
   (let loop ((continue #t))
      (if (not continue)
	  (trace-K)
	  (let liip ((At       A-tail)
		     (continue #f))
	     (if (null? At)
		 (loop continue)
		 (let ((integ (if (global? (cadr (car At)))
				  (global-info (cadr (car At)))
				  (local-info  (cadr (car At))))))
		    (if (null? (integ-K* integ))
			(loop continue)
			(let laap ((Ks       (integ-K* integ))
				   (continue continue))
			   (if (null? Ks)
			       (liip (cdr At) continue)
			       (let* ((f      (car (car At)))
				      (finteg (if (local? f)
						  (local-info f)
						  (global-info f)))
				      (k      (car Ks)))
				  (if (memq k (integ-K* finteg))
				      (laap (cdr Ks) continue)
				      (begin
					 (integ-K*-set! finteg
							(cons k (integ-K*
								 finteg)))
					 (laap (cdr Ks) #t)))))))))))))

;*---------------------------------------------------------------------*/
;*    trace-K ...                                                      */
;*---------------------------------------------------------------------*/
(define (trace-K)
   (when-trace 'integ
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (for-each (lambda (p)
			       (let ((integ (if (local? p)
						(local-info p)
						(global-info p))))
				  (fprint *trace-port*
					  " --> " (shape p) #\: #\Newline
					  "   K : " (shape (integ-K integ))
					  #\Newline
					  "   K*: " (shape (integ-K* integ))
					  #\Newline)))
			    *phi*)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))


		       
		    

	     
	  
