;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../definition.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 15 09:30:31 1993                          */
;*    Last change :  Thu Jan 20 02:17:59 1994 (serrano)                */
;*                                                                     */
;*    L'integration a partir d'une definition globalisee               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_definition
   (include "Tools/trace.sch"
	    "Var/variable.sch"
	    "Integ/integ.sch")
   (import  tools_error
	    tools_shape
	    heap_abstract
	    engine_param
	    integ_agraph
	    integ_kk
	    integ_cn
	    integ_kapture
	    integ_expression)
   (export (integ-definition var)))

;*---------------------------------------------------------------------*/
;*    integ-definition ...                                             */
;*    -------------------------------------------------------------    */
;*    La premiere chose a faire, comme pour la globalisation est de    */
;*    voir s'il y a des fonctions locales et s'il faut en globaliser   */
;*    certaines                                                        */
;*    -------------------------------------------------------------    */
;*    Cette globalisation ressemble un peu a la precedente. Son        */
;*    explication theorique se trouve dans la these de N.Seniak, page  */
;*    100. Voici qu'elles vont etre les etapes du calcul:              */
;*       1- Calcul de Phi. Le Phi qui nous concerne ici est un Phi     */
;*          restreint. Voici la definition de Phi:                     */
;*          Phi = { f ap PHI ^ nG( f ) }. ie. Phi = PHI moins toutes   */
;*          les fonctions qui ont ete globalisees par Lift.            */
;*          On n'a pas besoin de calcul Ephi car on sait que cet       */
;*          ensemble est vide                                          */
;*       2- Calcul de A.                                               */
;*       3- Calcul de K                                                */
;*       4- Calcul de K*                                               */
;*       5- U                                                          */
;*       6- Calcul de CN, CT, G                                        */
;*---------------------------------------------------------------------*/
(define (integ-definition var)
   (trace integ
	  "========================================" #\newline
	  (shape var) #\Newline
	  "----------------------------------------" #\newline)
   (let ((body (cond
		  ((global? var)
		   (global-info-set! var (make-integ))
		   (integ-kaptured-set! (global-info var) #f)
		   (integ-celled-set!   (global-info var) #f)
		   (for-each (lambda (a)
				(let ((integ (make-integ)))
				   (integ-kaptured?-set! integ #f)
				   (integ-celled-set!    integ #f)
				   (if (local-celled? a)
				       (integ-celled-set! integ #t))
				   (integ-owner-set!     integ var)
				   (local-info-set!      a integ)))
			     (function-args (global-value var)))
		   (function-body (global-value var)))
		  ((eq? (local-class var) 'function)
		   (local-info-set! var (make-integ))
		   (integ-kaptured-set! (local-info var) #f)
		   (integ-old-G?-set! (local-info var) #t)
		   (integ-celled-set! (local-info var) #f)
		   (for-each (lambda (a)
				(let ((integ (make-integ)))
				   (integ-kaptured?-set! integ #f)
				   (integ-celled-set!    integ #f)
				   (if (local-celled? a)
				       (integ-celled-set! integ #t))
				   (integ-owner-set! integ var)
				   (local-info-set! a integ)))
			     (function-args (local-value var)))
		   (function-body (local-value var)))
		  (else
		   (local-info-set! var (make-integ))
		   (integ-kaptured-set! (local-info var) #f)
		   (integ-celled-set!   (local-info var) #f)
		   (integ-old-G?-set! (local-info var) #t)
		   (for-each (lambda (a)
				(let ((integ (make-integ)))
				   (integ-kaptured?-set! integ #f)
				   (integ-celled-set!    integ #f)
				   (if (local-celled? a)
				       (integ-celled-set! integ #t))
				   (integ-owner-set! integ var)
				   (local-info-set! a integ)))
			     (return-args (local-value var)))
		   (return-body (local-value var))))))
      (set! *phi* (list var))
      (let ((A (a-graph var body)))
	 (trace-a-graph A)
	 (K*! (k! A var))
	 (U!)
	 (let ((G (Cn&Ct! var A)))
	    ;; on calcule les variables capturees pour chaque fonction
	    ;; globalisee
	    (for-each (lambda (g)
			 (let ((key (get-new-key)))
			    (get-kaptured! g key key)))
		      G)
	    (trace-kaptured G)
	    ;; on construit le nouveau corps de la fonction globale
	    (let (value body args)
	       (if (global? var)
		   (begin
		      (set! value (global-value var))
		      (set! body  (function-body value))
		      (set! args  (function-args value))
		      (function-body-set! value
					  (let-indirect
		     			   args
					   (integ-expression body var))))
		   (if (eq? (local-class var) 'function)
		       (begin
			  (set! value (local-value var))
			  (set! body  (function-body value))
			  (set! args  (function-args value))
			  (function-body-set! value
					      (let-indirect
					       args
					       (integ-expression body var))))
		       (begin
			  (set! value (local-value var))
			  (set! body  (return-body value))
			  (set! args  (return-args value))
			  (return-body-set! value
					    (integ-expression body var)))))
	       ;; on construit le resultat
	       (let loop ((G   G)
			  (res (list var)))
		  (if (null? G)
		      res
		      (let ((v (local-value (car G))))
			 (loop (cdr G)
			       (cons
				(if (eq? (local-class (car G)) 'function)
				    (make-local-R-definition (car G)
							     (function-args v)
							     (function-body v))
				    (make-local-C-definition (car G)
							     (return-body v)))
				res))))))))))

;*---------------------------------------------------------------------*/
;*    make-local-C-definition ...                                      */
;*---------------------------------------------------------------------*/
(define (make-local-C-definition var body)
   (trace integ
	  "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" #\Newline
	  "make-local-C-definition: " (shape var) #\Newline
	  "----------------------------------------" #\Newline)
   (let ((formals (integ-kaptured (local-info var)))
	 (body    `(gblock ,var
			   ,(integ-expression (labels-integrates var body)
					      var)))
	 (value   (local-value var)))
      (return-args-set! value formals)
      (return-body-set! value body)
      var))
    
;*---------------------------------------------------------------------*/
;*    make-local-R-definition ...                                      */
;*---------------------------------------------------------------------*/
(define (make-local-R-definition var formals body)
    (trace integ
	  "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" #\Newline
	  "make-local-R-definition: " (shape var) " " (shape formals) #\Newline
	  "----------------------------------------" #\Newline)
   (let ((formals (append (integ-kaptured (local-info var))
			  formals))
	 (body    (let-indirect (function-args (local-value var))
				(integ-expression (labels-integrates var body)
						  var)))
	 (value   (local-value var)))
      (function-args-set! value formals)
      (function-body-set! value body)
      var))
   
;*---------------------------------------------------------------------*/
;*    let-indirect ...                                                 */
;*---------------------------------------------------------------------*/
(define (let-indirect arg* exp)
   (trace integ "let-indirect     : " (shape arg*) #\Newline)
   (let loop ((arg*  arg*)
	      (decl* '()))
      (if (null? arg*)
	  (if (null? decl*)
	      exp
	      `(begin ,@decl* ,exp))
	  (if (and (eq? (local-access (car arg*)) 'write)
		   (or (integ-kaptured? (local-info (car arg*))) *call/cc?*)
		   (not (integ-celled (local-info (car arg*)))))
	      (loop (cdr arg*)
		    (cons `(set! ,(car arg*) ,(abstract-make-cell (car arg*)))
			  decl*))
	      (loop (cdr arg*) decl*)))))
					  
;*---------------------------------------------------------------------*/
;*    labels-integrates ...                                            */
;*---------------------------------------------------------------------*/
(define (labels-integrates var body)
   (trace integ "labels-integrates: " (shape var) " ==> "
	  (shape (integ-integrates (local-info var))) #\Newline)
   `(labels ,(map (lambda (i)
		     `(,i ,(function-args (local-value i))
			  ,(function-body (local-value i))))
		  (integ-integrates (local-info var)))
       ,body))  
